(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    195407,       4725]
NotebookOptionsPosition[    178583,       4170]
NotebookOutlinePosition[    181054,       4243]
CellTagsIndexPosition[    180580,       4229]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "\:0e41\:0e19\:0e30\:0e19\:0e33\:0e01\:0e32\:0e23\:0e43\:0e0a\:0e49 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \:0e40\:0e1a\:0e37\:0e49\:0e2d\:0e07\:0e15\:0e49\:0e19\:0e2a\:0e33\:0e2b\
\:0e23\:0e31\:0e1a\:0e19\:0e31\:0e01\:0e28\:0e36\:0e01\:0e29\:0e32\:0e14\:0e49\
\:0e32\:0e19\:0e27\:0e34\:0e17\:0e22\:0e32\:0e28\:0e32\:0e2a\:0e15\:0e23\:0e4c"
}], "Title"],

Cell[TextData[{
 StyleBox["\:0e23\:0e27\:0e1a\:0e23\:0e27\:0e21\:0e42\:0e14\:0e22 ", 
  "Subsubtitle"],
 ButtonBox["\:0e1e\:0e07\:0e28\:0e01\:0e23 \:0e2a\:0e32\:0e22\:0e40\:0e1e\
\:0e47\:0e0a\:0e23\:0e4c",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://kostuff.blogspot.com/"], None}]
}], "Subtitle"],

Cell[TextData[{
 "\:0e01\:0e25\:0e31\:0e1a\:0e44\:0e1b",
 ButtonBox["\:0e2b\:0e19\:0e49\:0e32\:0e41\:0e23\:0e01",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{
      ParentDirectory[]}, "index.html", CharacterEncoding -> "WindowsANSI"], 
    None}]
}], "Subtitle"],

Cell[TextData[StyleBox["\:0e15\:0e2d\:0e19\:0e17\:0e35\:0e48 2: \:0e01\:0e32\
\:0e23\:0e04\:0e33\:0e19\:0e27\:0e13\:0e40\:0e1a\:0e37\:0e49\:0e2d\:0e07\:0e15\
\:0e49\:0e19", "Section"]], "Subtitle"],

Cell[CellGroupData[{

Cell["\<\
\:0e01\:0e32\:0e23\:0e04\:0e33\:0e19\:0e27\:0e13\:0e41\:0e1a\:0e1a\:0e04\:0e48\
\:0e32\:0e41\:0e17\:0e49\:0e08\:0e23\:0e34\:0e07 (exact) \:0e41\:0e25\:0e30 \
\:0e04\:0e48\:0e32\:0e1b\:0e23\:0e30\:0e21\:0e32\:0e13 (approximate)\
\>", "Subsection"],

Cell[TextData[{
 "\:0e42\:0e14\:0e22\:0e1b\:0e01\:0e15\:0e34 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \:0e08\:0e30\:0e1e\:0e22\:0e32\:0e22\:0e32\:0e21\:0e43\:0e2b\:0e49\:0e1c\
\:0e25\:0e25\:0e31\:0e1e\:0e17\:0e4c\:0e17\:0e35\:0e48\:0e40\:0e1b\:0e47\:0e19\
\:0e04\:0e48\:0e32\:0e41\:0e17\:0e49\:0e08\:0e23\:0e34\:0e07 \:0e16\:0e49\
\:0e32\:0e1c\:0e25\:0e01\:0e32\:0e23\:0e04\:0e33\:0e19\:0e27\:0e13\:0e15\:0e34\
\:0e14 \:0e04\:0e48\:0e32 \[Pi], \:0e04\:0e48\:0e32 \[ExponentialE], ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]]],
 ", \:0e08\:0e33\:0e19\:0e27\:0e19\:0e40\:0e15\:0e47\:0e21, \
\:0e2b\:0e23\:0e37\:0e2d\:0e04\:0e48\:0e32\:0e17\:0e35\:0e48\:0e44\:0e21\:0e48\
\:0e43\:0e0a\:0e48\:0e17\:0e28\:0e19\:0e34\:0e22\:0e21\:0e08\:0e33\:0e01\:0e31\
\:0e14 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \:0e01\:0e47\:0e08\:0e30\:0e40\:0e02\:0e35\:0e22\:0e19\:0e04\:0e48\:0e32\
\:0e40\:0e2b\:0e25\:0e48\:0e32\:0e19\:0e31\:0e49\:0e19\:0e44\:0e27\:0e49  \
\:0e40\:0e0a\:0e48\:0e19"
}], "Text"],

Cell["\:0e40\:0e28\:0e29\:0e2a\:0e48\:0e27\:0e19", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "/", "2"}], " ", "+", " ", 
  RowBox[{"1", "/", "3"}], "+", 
  RowBox[{"1", "/", "4"}], "+", 
  RowBox[{"1", "/", "5"}], "+", 
  RowBox[{"1", "/", "6"}]}]], "Input"],

Cell[BoxData[
 FractionBox["29", "20"]], "Output",
 CellChangeTimes->{3.583662834859784*^9, 3.583662987191033*^9, 
  3.5836635762456837`*^9}]
}, Open  ]],

Cell["\:0e15\:0e23\:0e35\:0e42\:0e01\:0e13\:0e21\:0e34\:0e15\:0e34", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"3", 
   RowBox[{"Pi", "/", "4"}]}], "]"}]], "Input"],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox["2"]]], "Output",
 CellChangeTimes->{3.583662835089819*^9, 3.583662987262472*^9, 
  3.5836635763642483`*^9}]
}, Open  ]],

Cell["\<\
\:0e25\:0e2d\:0e01\:0e32\:0e23\:0e34\:0e17\:0e36\:0e21 (Log[ ] \:0e04\:0e37\
\:0e2d \:0e25\:0e2d\:0e01\:0e10\:0e32\:0e19 \[ExponentialE] )\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", "10", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Log", "[", "10", "]"}]], "Output",
 CellChangeTimes->{3.583662835124736*^9, 3.583662987296678*^9, 
  3.583663576412878*^9}]
}, Open  ]],

Cell["\<\
\:0e16\:0e49\:0e32\:0e15\:0e49\:0e2d\:0e07\:0e01\:0e32\:0e23\:0e04\:0e48\:0e32\
\:0e1b\:0e23\:0e30\:0e21\:0e32\:0e13\:0e40\:0e1b\:0e47\:0e19 \:0e17\:0e28\
\:0e19\:0e34\:0e22\:0e21 \:0e40\:0e23\:0e32\:0e01\:0e47\:0e04\:0e27\:0e23\
\:0e43\:0e0a\:0e49 \:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19 N[ ]\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], " ", "+", " ", 
   RowBox[{"1", "/", "3"}], "+", 
   RowBox[{"1", "/", "4"}], "+", 
   RowBox[{"1", "/", "5"}], "+", 
   RowBox[{"1", "/", "6"}]}], "]"}]], "Input"],

Cell[BoxData["1.45`"], "Output",
 CellChangeTimes->{3.583662835173656*^9, 3.583662987332511*^9, 
  3.583663576481122*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Sin", "[", 
   RowBox[{"3", 
    RowBox[{"Pi", "/", "4"}]}], "]"}], "]"}]], "Input"],

Cell[BoxData["0.7071067811865475`"], "Output",
 CellChangeTimes->{3.583662835224043*^9, 3.583662987366028*^9, 
  3.583663576546155*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Log", "[", "10", "]"}], "]"}]], "Input"],

Cell[BoxData["2.302585092994046`"], "Output",
 CellChangeTimes->{3.583662835269576*^9, 3.583662987399953*^9, 
  3.5836635766124372`*^9}]
}, Open  ]],

Cell["\<\
\:0e40\:0e23\:0e32\:0e2a\:0e32\:0e21\:0e32\:0e23\:0e16\:0e43\:0e0a\:0e49 \
\:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19 N[ ] \
\:0e43\:0e19\:0e2d\:0e35\:0e01\:0e23\:0e39\:0e1b\:0e17\:0e35\:0e48\:0e40\:0e23\
\:0e35\:0e22\:0e01\:0e27\:0e48\:0e32 postfix form \:0e42\:0e14\:0e22\:0e40\
\:0e02\:0e35\:0e22\:0e19 // N\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "2"}], " ", "+", " ", 
    RowBox[{"1", "/", "3"}], "+", 
    RowBox[{"1", "/", "4"}], "+", 
    RowBox[{"1", "/", "5"}], "+", 
    RowBox[{"1", "/", "6"}]}], "//", "N"}],
  FormatType->StandardForm]], "Input"],

Cell[BoxData["1.45`"], "Output",
 CellChangeTimes->{3.583662835324254*^9, 3.583662987433408*^9, 
  3.583663576679617*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"3", 
    RowBox[{"Pi", "/", "4"}]}], "]"}], "//", "N"}]], "Input"],

Cell[BoxData["0.7071067811865475`"], "Output",
 CellChangeTimes->{3.583662835373868*^9, 3.583662987466646*^9, 
  3.5836635767462673`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", "10", "]"}], "//", "N"}]], "Input"],

Cell[BoxData["2.302585092994046`"], "Output",
 CellChangeTimes->{3.583662835424159*^9, 3.5836629875004597`*^9, 
  3.5836635767980013`*^9}]
}, Open  ]],

Cell["\<\
\:0e40\:0e23\:0e32\:0e2a\:0e32\:0e21\:0e32\:0e23\:0e16\:0e43\:0e2a\:0e48\:0e08\
\:0e33\:0e19\:0e27\:0e19\:0e15\:0e33\:0e41\:0e2b\:0e19\:0e48\:0e07\:0e19\:0e31\
\:0e22\:0e2a\:0e33\:0e04\:0e31\:0e0d\:0e17\:0e35\:0e48\:0e15\:0e49\:0e2d\:0e07\
\:0e01\:0e32\:0e23\:0e40\:0e02\:0e49\:0e32\:0e44\:0e1b\:0e43\:0e19\:0e1f\:0e31\
\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19 N[ ] \:0e14\:0e49\:0e27\:0e22\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "2"}], " ", "+", " ", 
    RowBox[{"1", "/", "3"}], "+", 
    RowBox[{"1", "/", "4"}], "+", 
    RowBox[{"1", "/", "5"}], "+", 
    RowBox[{"1", "/", "6"}]}], ",", " ", "20"}], "]"}]], "Input"],

Cell[BoxData["1.45`20."], "Output",
 CellChangeTimes->{3.5836628354755487`*^9, 3.583662987540172*^9, 
  3.583663576866466*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"3", 
     RowBox[{"Pi", "/", "4"}]}], "]"}], ",", "20"}], "]"}]], "Input"],

Cell[BoxData["0.707106781186547524400844362104849039284835937688474036588`20.\
"], "Output",
 CellChangeTimes->{3.58366283552035*^9, 3.583662987580451*^9, 
  3.583663576929577*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Log", "[", "10", "]"}], ",", "40"}], "]"}]], "Input"],

Cell[BoxData["2.\
30258509299404568401799145468436420760110194081843466493337486492263245247634`\
40."], "Output",
 CellChangeTimes->{3.583662835574018*^9, 3.583662987630609*^9, 
  3.583663576995576*^9}]
}, Open  ]],

Cell["\<\
\:0e16\:0e49\:0e32\:0e40\:0e23\:0e32\:0e43\:0e2a\:0e48\:0e08\:0e38\:0e14\:0e17\
\:0e28\:0e19\:0e34\:0e22\:0e21\:0e43\:0e19\:0e01\:0e32\:0e23\:0e04\:0e33\:0e19\
\:0e27\:0e13 \:0e1c\:0e25\:0e25\:0e31\:0e1e\:0e17\:0e4c\:0e08\:0e30\:0e40\
\:0e1b\:0e47\:0e19\:0e04\:0e48\:0e32\:0e1b\:0e23\:0e30\:0e21\:0e32\:0e13\:0e17\
\:0e31\:0e19\:0e17\:0e35\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1.0", "/", "2"}], " ", "+", " ", 
  RowBox[{"1", "/", "3"}], "+", 
  RowBox[{"1", "/", "4"}], "+", 
  RowBox[{"1", "/", "5"}], "+", 
  RowBox[{"1", "/", "6"}]}]], "Input"],

Cell[BoxData["1.45`"], "Output",
 CellChangeTimes->{3.5836628356245003`*^9, 3.583662987681238*^9, 
  3.583663577062717*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"3", 
   RowBox[{"Pi", "/", "4."}]}], "]"}]], "Input"],

Cell[BoxData["0.7071067811865476`"], "Output",
 CellChangeTimes->{3.5836628356746798`*^9, 3.583662987730838*^9, 
  3.58366357713125*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", "10.", "]"}]], "Input"],

Cell[BoxData["2.302585092994046`"], "Output",
 CellChangeTimes->{3.58366283572414*^9, 3.583662987781247*^9, 
  3.583663577198284*^9}]
}, Open  ]],

Cell["\<\
\:0e40\:0e04\:0e23\:0e37\:0e48\:0e2d\:0e07\:0e2b\:0e21\:0e32\:0e22\:0e01\:0e32\
\:0e23\:0e04\:0e33\:0e19\:0e27\:0e13\:0e08\:0e30\:0e40\:0e1b\:0e47\:0e19\:0e41\
\:0e1a\:0e1a\:0e19\:0e35\:0e49
\:0e1a\:0e27\:0e01: x+y
\:0e25\:0e1a: x-y
\:0e04\:0e39\:0e13: x y \:0e2b\:0e23\:0e37\:0e2d x*y
\:0e2b\:0e32\:0e23: x/y
\:0e22\:0e01\:0e01\:0e33\:0e25\:0e31\:0e07: x^y 
\:0e15\:0e34\:0e14\:0e25\:0e1a: -x\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", "1"}]], "Input"],

Cell[BoxData["2"], "Output",
 CellChangeTimes->{3.583662835771044*^9, 3.5836629878314734`*^9, 
  3.583663577264647*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"3", "-", "5"}]], "Input"],

Cell[BoxData[
 RowBox[{"-", "2"}]], "Output",
 CellChangeTimes->{3.583662835824564*^9, 3.5836629878803587`*^9, 
  3.583663577359455*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pi", " ", 
  RowBox[{"r", "^", "2"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"\[Pi]", " ", 
  SuperscriptBox["r", "2"]}]], "Output",
 CellChangeTimes->{3.583662835874937*^9, 3.583662987929654*^9, 
  3.583663577415605*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", 
   RowBox[{"Pi", "/", "4"}], "]"}], "/", 
  RowBox[{"Sin", "[", 
   RowBox[{"Pi", "/", "4"}], "]"}]}]], "Input"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.583662835961478*^9, 3.583662987981123*^9, 
  3.583663577479313*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "^", "30"}]], "Input"],

Cell[BoxData["1073741824"], "Output",
 CellChangeTimes->{3.5836628360035353`*^9, 3.5836629880310993`*^9, 
  3.583663577531199*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2", "^", "30"}], " ", "//", "N"}]], "Input"],

Cell[BoxData["1.073741824`*^9"], "Output",
 CellChangeTimes->{3.5836628360362177`*^9, 3.583662988066895*^9, 
  3.583663577596135*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
\:0e08\:0e33\:0e19\:0e27\:0e19\:0e40\:0e0a\:0e34\:0e07\:0e0b\:0e49\:0e2d\:0e19\
\>", "Subsection"],

Cell[TextData[{
 "\:0e40\:0e23\:0e32\:0e08\:0e30\:0e43\:0e0a\:0e49 I \:0e40\:0e1e\:0e37\:0e48\
\:0e2d\:0e41\:0e17\:0e19\:0e1b\:0e23\:0e34\:0e21\:0e32\:0e13 ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"-", "1"}]], TraditionalForm]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"I", "^", "2"}]], "Input"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellChangeTimes->{3.5836628360918503`*^9, 3.5836629880994377`*^9, 
  3.583663577643531*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", "I"}]], "Input"],

Cell[BoxData[
 RowBox[{"1", "+", "\[ImaginaryI]"}]], "Output",
 CellChangeTimes->{3.583662836140493*^9, 3.583662988135352*^9, 
  3.583663577712966*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", "I"}], ")"}], 
  RowBox[{"(", 
   RowBox[{"1", "-", "I"}], ")"}]}]], "Input"],

Cell[BoxData["2"], "Output",
 CellChangeTimes->{3.583662836206628*^9, 3.583662988182165*^9, 
  3.583663577765457*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", "I"}], ")"}], "^", "5"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "4"}], "-", 
  RowBox[{"4", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{3.583662836239455*^9, 3.583662988216868*^9, 
  3.58366357783048*^9}]
}, Open  ]],

Cell["\<\
Re[ ] \:0e41\:0e25\:0e30 Im[ ] \:0e04\:0e37\:0e2d\:0e2a\:0e48\:0e27\:0e19\
\:0e08\:0e23\:0e34\:0e07\:0e41\:0e25\:0e30\:0e2a\:0e48\:0e27\:0e19\:0e08\:0e34\
\:0e19\:0e15\:0e20\:0e32\:0e1e\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Re", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", "I"}]}], "]"}]], "Input"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.583662836290451*^9, 3.583662988293817*^9, 
  3.583663577896999*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Im", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", "I"}]}], "]"}]], "Input"],

Cell[BoxData["2"], "Output",
 CellChangeTimes->{3.5836628363411217`*^9, 3.583662988330027*^9, 
  3.583663577961101*^9}]
}, Open  ]],

Cell["Abs[ ] \:0e04\:0e37\:0e2d\:0e02\:0e19\:0e32\:0e14", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", "I"}]}], "]"}]], "Input"],

Cell[BoxData[
 SqrtBox["5"]], "Output",
 CellChangeTimes->{3.583662836386846*^9, 3.583662988380899*^9, 
  3.58366357802556*^9}]
}, Open  ]],

Cell["Arg[ ] \:0e04\:0e37\:0e2d\:0e21\:0e38\:0e21\:0e43\:0e19\:0e23\:0e39\
\:0e1b\:0e42\:0e1e\:0e25\:0e32\:0e23\:0e4c", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Arg", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", "I"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"ArcTan", "[", "2", "]"}]], "Output",
 CellChangeTimes->{3.583662836441058*^9, 3.583662988416854*^9, 
  3.5836635780805273`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Arg", "[", 
  RowBox[{"1", "-", "I"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["\[Pi]", "4"]}]], "Output",
 CellChangeTimes->{3.583662836490844*^9, 3.583662988449566*^9, 
  3.583663578130767*^9}]
}, Open  ]],

Cell["Conjugate[ ] \:0e04\:0e37\:0e2d\:0e04\:0e48\:0e32\:0e04\:0e2d\:0e19\
\:0e08\:0e39\:0e40\:0e01\:0e15", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Conjugate", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", "I"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"2", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{3.5836628365403023`*^9, 3.5836629884834414`*^9, 
  3.583663578173994*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Conjugate", "[", 
  RowBox[{"Conjugate", "[", 
   RowBox[{"1", "+", 
    RowBox[{"2", "I"}]}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{3.583662836590818*^9, 3.583662988516129*^9, 
  3.583663578249386*^9}]
}, Open  ]],

Cell["\<\
ComplexExpand[ ] \:0e08\:0e30\:0e01\:0e23\:0e30\:0e08\:0e32\:0e22 \
\:0e19\:0e34\:0e1e\:0e08\:0e19\:0e4c (expression) \:0e42\:0e14\:0e22\:0e01\
\:0e33\:0e2b\:0e19\:0e14\:0e27\:0e48\:0e32\:0e15\:0e31\:0e27\:0e41\:0e1b\:0e23\
\:0e15\:0e48\:0e32\:0e07\:0e46\:0e40\:0e1b\:0e47\:0e19\:0e08\:0e33\:0e19\:0e27\
\:0e19\:0e08\:0e23\:0e34\:0e07\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "I"}]}], ")"}], "^", "3"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "3"], "-", 
  RowBox[{"3", " ", "a", " ", 
   SuperscriptBox["b", "2"]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"3", " ", 
      SuperscriptBox["a", "2"], " ", "b"}], "-", 
     SuperscriptBox["b", "3"]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.583662836624301*^9, 3.583662988549736*^9, 
  3.583663578296178*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"Cos", "[", 
   RowBox[{"a", " ", "+", " ", 
    RowBox[{"b", " ", "I"}]}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cos", "[", "a", "]"}], " ", 
   RowBox[{"Cosh", "[", "b", "]"}]}], "-", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Sin", "[", "a", "]"}], " ", 
   RowBox[{"Sinh", "[", "b", "]"}]}]}]], "Output",
 CellChangeTimes->{3.583662836674642*^9, 3.583662988585802*^9, 
  3.583663578475428*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "I"}]}], "]"}], "/", 
   RowBox[{"Cos", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "I"}]}], "]"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "a"}], "]"}], 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "a"}], "]"}], "+", 
    RowBox[{"Cosh", "[", 
     RowBox[{"2", " ", "b"}], "]"}]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"Sinh", "[", 
     RowBox[{"2", " ", "b"}], "]"}]}], 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "a"}], "]"}], "+", 
    RowBox[{"Cosh", "[", 
     RowBox[{"2", " ", "b"}], "]"}]}]]}]], "Output",
 CellChangeTimes->{3.583662836724065*^9, 3.583662988631036*^9, 
  3.5836635785533533`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"Tan", "[", 
   RowBox[{"a", "+", 
    RowBox[{"b", " ", "I"}]}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "a"}], "]"}], 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "a"}], "]"}], "+", 
    RowBox[{"Cosh", "[", 
     RowBox[{"2", " ", "b"}], "]"}]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"Sinh", "[", 
     RowBox[{"2", " ", "b"}], "]"}]}], 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "a"}], "]"}], "+", 
    RowBox[{"Cosh", "[", 
     RowBox[{"2", " ", "b"}], "]"}]}]]}]], "Output",
 CellChangeTimes->{3.583662836770835*^9, 3.583662988681332*^9, 
  3.5836635786393423`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\:0e15\:0e31\:0e27\:0e41\:0e1b\:0e23", "Subsection"],

Cell["\<\
\:0e40\:0e23\:0e32\:0e2a\:0e32\:0e21\:0e32\:0e23\:0e16\:0e43\:0e0a\:0e49\:0e15\
\:0e31\:0e27\:0e41\:0e1b\:0e25\:0e40\:0e01\:0e47\:0e1a\:0e04\:0e48\:0e32\:0e15\
\:0e48\:0e32\:0e07\:0e46\:0e44\:0e14\:0e49 \:0e14\:0e49\:0e27\:0e22\:0e40\
\:0e04\:0e23\:0e37\:0e48\:0e2d\:0e07\:0e2b\:0e21\:0e32\:0e22 = \:0e41\:0e1a\
\:0e1a\:0e19\:0e35\:0e49\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"avo", " ", "=", " ", 
  RowBox[{"6.02", " ", 
   RowBox[{"10", "^", "23"}]}]}]], "Input"],

Cell[BoxData["6.019999999999999`*^23"], "Output",
 CellChangeTimes->{3.583662836824542*^9, 3.5836629887294893`*^9, 
  3.58366357872007*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mol", " ", "=", " ", "3"}]], "Input"],

Cell[BoxData["3"], "Output",
 CellChangeTimes->{3.5836628368758497`*^9, 3.5836629887804956`*^9, 
  3.58366357878547*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mol", " ", "avo"}]], "Input"],

Cell[BoxData["1.8059999999999998`*^24"], "Output",
 CellChangeTimes->{3.583662836919734*^9, 3.583662988831352*^9, 
  3.583663578853772*^9}]
}, Open  ]],

Cell["\<\
\:0e2b\:0e25\:0e31\:0e07\:0e08\:0e32\:0e01\:0e40\:0e23\:0e32\:0e43\:0e0a\:0e49\
\:0e15\:0e31\:0e27\:0e41\:0e1b\:0e23\:0e40\:0e2a\:0e23\:0e47\:0e08\:0e41\:0e25\
\:0e49\:0e27 \:0e40\:0e23\:0e32\:0e04\:0e27\:0e23\:0e17\:0e35\:0e48\:0e08\
\:0e30\:0e25\:0e49\:0e32\:0e07\:0e04\:0e48\:0e32 (Clear[ ])\:0e2b\:0e23\:0e37\
\:0e2d\:0e25\:0e1a (Remove[ ]) \:0e15\:0e31\:0e27\:0e41\:0e1b\:0e23\:0e40\
\:0e2b\:0e25\:0e48\:0e32\:0e19\:0e31\:0e49\:0e19\:0e40\:0e2a\:0e35\:0e22 \
\:0e40\:0e19\:0e37\:0e48\:0e2d\:0e07\:0e08\:0e32\:0e01\:0e16\:0e49\:0e32\:0e40\
\:0e23\:0e32\:0e17\:0e34\:0e49\:0e07\:0e15\:0e31\:0e27\:0e41\:0e1b\:0e23\:0e40\
\:0e2b\:0e25\:0e48\:0e32\:0e19\:0e31\:0e49\:0e19\:0e44\:0e27\:0e49 \:0e40\
\:0e23\:0e32\:0e21\:0e31\:0e01\:0e08\:0e30\:0e43\:0e0a\:0e49\:0e04\:0e48\:0e32\
\:0e02\:0e2d\:0e07\:0e21\:0e31\:0e19\:0e42\:0e14\:0e22\:0e44\:0e21\:0e48\:0e15\
\:0e31\:0e49\:0e07\:0e43\:0e08\:0e17\:0e33\:0e43\:0e2b\:0e49\:0e40\:0e23\:0e32\
\:0e2a\:0e31\:0e1a\:0e2a\:0e19

\:0e40\:0e23\:0e32\:0e2a\:0e32\:0e21\:0e32\:0e23\:0e16\:0e43\:0e0a\:0e49 ? \
\:0e40\:0e1e\:0e37\:0e48\:0e2d\:0e41\:0e2a\:0e14\:0e07\:0e02\:0e49\:0e2d\:0e21\
\:0e39\:0e25\:0e40\:0e01\:0e35\:0e48\:0e22\:0e27\:0e01\:0e31\:0e1a\:0e15\:0e31\
\:0e27\:0e41\:0e1b\:0e23\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "avo"}]], "Input"],

Cell["Global`avo", "Print", "PrintUsage",
 CellChangeTimes->{3.583663579512596*^9},
 CellTags->"Info3583688778-1507343"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{"avo", "=", "6.019999999999999`*^23"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`avo],
  Editable->False]], "Print",
 CellChangeTimes->{3.583663579559806*^9},
 CellTags->"Info3583688778-1507343"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "mol"}]], "Input"],

Cell["Global`mol", "Print", "PrintUsage",
 CellChangeTimes->{3.5836635799520683`*^9},
 CellTags->"Info3583688779-1507343"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{"mol", "=", "3"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`mol],
  Editable->False]], "Print",
 CellChangeTimes->{3.5836635799935226`*^9},
 CellTags->"Info3583688779-1507343"]
}, Open  ]],

Cell["\<\
\:0e15\:0e48\:0e2d\:0e44\:0e1b\:0e40\:0e23\:0e32\:0e08\:0e30\:0e25\:0e49\:0e32\
\:0e07\:0e04\:0e48\:0e32 (Clear[])\:0e2b\:0e23\:0e37\:0e2d\:0e25\:0e1a \
(Remove[])\:0e15\:0e31\:0e27\:0e41\:0e1b\:0e23\:0e0a\:0e37\:0e48\:0e2d mol\
\>", "Text"],

Cell[BoxData[
 RowBox[{"Clear", "[", "mol", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "mol"}]], "Input"],

Cell["Global`mol", "Print", "PrintUsage",
 CellChangeTimes->{3.583663580336245*^9},
 CellTags->"Info3583688780-1507343"]
}, Open  ]],

Cell["\<\
Clear[mol] \:0e25\:0e49\:0e32\:0e07\:0e04\:0e48\:0e32\:0e17\:0e35\:0e48\:0e40\
\:0e04\:0e22\:0e01\:0e33\:0e2b\:0e19\:0e14\:0e43\:0e2b\:0e49 mol \:0e41\:0e15\
\:0e48\:0e15\:0e31\:0e27\:0e41\:0e1b\:0e23\:0e17\:0e35\:0e48\:0e0a\:0e37\:0e48\
\:0e2d\:0e27\:0e48\:0e32 mol \:0e22\:0e31\:0e07\:0e40\:0e1b\:0e47\:0e19\:0e17\
\:0e35\:0e48\:0e23\:0e39\:0e49\:0e08\:0e31\:0e01\
\>", "Text"],

Cell[BoxData[
 RowBox[{"Remove", "[", "mol", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "mol"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Information", "::", "notfound"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Symbol \[NoBreak]\\!\\(\\\"mol\\\"\\)\[NoBreak] not found. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/notfound\\\", \
ButtonNote -> \\\"Information::notfound\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.5836628388615313`*^9, 3.583662990175728*^9, 
  3.583663580657674*^9}]
}, Open  ]],

Cell["\<\
Remove[mol] \
\:0e25\:0e1a\:0e17\:0e38\:0e01\:0e2d\:0e22\:0e48\:0e32\:0e07\:0e17\:0e35\:0e48\
\:0e40\:0e01\:0e35\:0e48\:0e22\:0e27\:0e01\:0e31\:0e1a mol \
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
\:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19\:0e1e\:0e23\:0e49\:0e2d\:0e21\
\:0e43\:0e0a\:0e49 (Built-in Functions)\
\>", "Subsection"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \:0e21\:0e35\:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19\:0e1e\:0e23\
\:0e49\:0e2d\:0e21\:0e43\:0e0a\:0e49 (Built-in Functions) \:0e21\:0e32\:0e01\
\:0e21\:0e32\:0e22 \:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19\:0e08\
\:0e30\:0e43\:0e0a\:0e49\:0e27\:0e07\:0e40\:0e25\:0e47\:0e1a\:0e2a\:0e35\:0e48\
\:0e40\:0e2b\:0e25\:0e35\:0e48\:0e22\:0e21 [ ] \:0e25\:0e49\:0e2d\:0e21\:0e23\
\:0e2d\:0e1a\:0e04\:0e48\:0e32 argument \n\
\:0e0a\:0e37\:0e48\:0e2d\:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19\:0e17\
\:0e35\:0e48 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \:0e21\:0e35\:0e21\:0e32\:0e43\:0e2b\:0e49\:0e43\:0e0a\:0e49 \:0e08\:0e30\
\:0e02\:0e36\:0e49\:0e19\:0e15\:0e49\:0e19\:0e14\:0e49\:0e27\:0e22\:0e15\:0e31\
\:0e27\:0e2d\:0e31\:0e01\:0e29\:0e23\:0e15\:0e31\:0e27\:0e43\:0e2b\:0e0d\:0e48\
\n\n\:0e15\:0e31\:0e27\:0e2d\:0e22\:0e48\:0e32\:0e07\:0e1f\:0e31\:0e07\:0e04\
\:0e4c\:0e0a\:0e31\:0e19\:0e1e\:0e23\:0e49\:0e2d\:0e21\:0e43\:0e0a\:0e49:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", "Pi", "]"}]], "Input"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.583662838909684*^9, 3.5836629902334948`*^9, 
  3.58366358071316*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cos", "[", "Pi", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellChangeTimes->{3.583662838958123*^9, 3.583662990283634*^9, 
  3.583663580763341*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCos", "[", 
  RowBox[{"1", "/", 
   RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}]], "Input"],

Cell[BoxData[
 FractionBox["\[Pi]", "4"]], "Output",
 CellChangeTimes->{3.583662839008984*^9, 3.583662990333062*^9, 
  3.583663580878084*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTan", "[", "1", "]"}]], "Input"],

Cell[BoxData[
 FractionBox["\[Pi]", "4"]], "Output",
 CellChangeTimes->{3.583662839046565*^9, 3.583662990383376*^9, 
  3.5836635809293013`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", "E", "]"}]], "Input"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.583662839126862*^9, 3.583662990429658*^9, 
  3.5836635809967318`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", "1", "]"}]], "Input"],

Cell[BoxData["\[ExponentialE]"], "Output",
 CellChangeTimes->{3.583662839179778*^9, 3.583662990478896*^9, 
  3.5836635810636587`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", "9", "]"}]], "Input"],

Cell[BoxData["3"], "Output",
 CellChangeTimes->{3.5836628392329884`*^9, 3.5836629905332823`*^9, 
  3.5836635811317587`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{"-", "10"}], "]"}]], "Input"],

Cell[BoxData["10"], "Output",
 CellChangeTimes->{3.583662839275227*^9, 3.583662990737421*^9, 
  3.583663581180529*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{"11", ",", "3"}], "]"}]], "Input"],

Cell[BoxData["2"], "Output",
 CellChangeTimes->{3.5836628395082207`*^9, 3.583662990779292*^9, 
  3.583663581229644*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"5", "x"}], "+", 
     RowBox[{"x", "^", "2"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"2", "+", "x"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"3", "+", "x"}], ")"}]}], ")"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["3", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}]}]]}], "+", 
  FractionBox["5", 
   RowBox[{"2", "+", "x"}]], "-", 
  FractionBox["5", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"3", "+", "x"}], ")"}]}]]}]], "Output",
 CellChangeTimes->{3.583662839564423*^9, 3.5836629908128653`*^9, 
  3.5836635812821712`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"1", "+", "x", "+", 
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"x", "^", "3"}], "+", 
   RowBox[{"x", "^", "4"}], "+", 
   RowBox[{"x", "^", "5"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", "x", "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x", "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 CellChangeTimes->{3.5836628396078*^9, 3.583662990863312*^9, 
  3.583663581325782*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", "768", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.583662839647711*^9, 3.583662990913116*^9, 
  3.5836635813803463`*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \:0e21\:0e35\:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19\:0e1e\:0e23\
\:0e49\:0e2d\:0e21\:0e43\:0e0a\:0e49\:0e2b\:0e25\:0e32\:0e22\:0e1e\:0e31\:0e19\
\:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19 \:0e16\:0e49\:0e32\:0e15\
\:0e49\:0e2d\:0e07\:0e01\:0e32\:0e23\:0e23\:0e39\:0e49\:0e40\:0e01\:0e35\:0e48\
\:0e22\:0e27\:0e01\:0e31\:0e1a\:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19\
\:0e2d\:0e30\:0e44\:0e23 \:0e43\:0e2b\:0e49\:0e40\:0e1b\:0e34\:0e14 \
Help/Master Index \:0e14\:0e39 \:0e2b\:0e23\:0e37\:0e2d\:0e1e\:0e34\:0e21\
\:0e1e\:0e4c\:0e40\:0e04\:0e23\:0e37\:0e48\:0e2d\:0e07\:0e2b\:0e21\:0e32\:0e22\
\:0e04\:0e33\:0e16\:0e32\:0e21 ? \:0e41\:0e1a\:0e1a\:0e19\:0e35\:0e49"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Apart"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"Apart\\\", \\\"[\\\", \
StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\"]\\\"}]\) rewrites a rational \
expression as a sum of terms with minimal denominators. \
\\n\!\(\*RowBox[{\\\"Apart\\\", \\\"[\\\", RowBox[{StyleBox[\\\"expr\\\", \
\\\"TI\\\"], \\\",\\\", StyleBox[\\\"var\\\", \\\"TI\\\"]}], \\\"]\\\"}]\) \
treats all variables other than \!\(\*StyleBox[\\\"var\\\", \\\"TI\\\"]\) as \
constants. \"\>", "MSG"], "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apart"]}]], "Print", "PrintUsage",
 CellChangeTimes->{3.5836635816732483`*^9},
 CellTags->"Info3583688781-1507343"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "FactorInteger"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"FactorInteger\\\", \\\"[\\\", \
StyleBox[\\\"n\\\", \\\"TI\\\"], \\\"]\\\"}]\) gives a list of the prime \
factors of the integer \!\(\*StyleBox[\\\"n\\\", \\\"TI\\\"]\), together with \
their exponents. \\n\!\(\*RowBox[{\\\"FactorInteger\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"n\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"k\\\", \
\\\"TI\\\"]}], \\\"]\\\"}]\) does partial factorization, pulling out at most \
\!\(\*StyleBox[\\\"k\\\", \\\"TI\\\"]\) distinct factors.\"\>", "MSG"], 
  "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorInteger"]}]], "Print", "PrintUsage",
 CellChangeTimes->{3.583663582057272*^9},
 CellTags->"Info3583688781-1507343"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Random"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"Random\\\", \\\"[\\\", \\\"]\\\"}]\) gives \
a uniformly distributed pseudorandom Real in the range 0 to 1. \
\\n\!\(\*RowBox[{\\\"Random\\\", \\\"[\\\", RowBox[{StyleBox[\\\"type\\\", \\\
\"TI\\\"], \\\",\\\", StyleBox[\\\"range\\\", \\\"TI\\\"]}], \\\"]\\\"}]\) \
gives a pseudorandom number of the specified type, lying in the specified \
range. Possible types are: Integer, Real and Complex. The default range is 0 \
to 1. You can give the range \!\(\*RowBox[{\\\"{\\\", \
RowBox[{StyleBox[\\\"min\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"max\\\", \
\\\"TI\\\"]}], \\\"}\\\"}]\) explicitly; a range specification of \
\!\(\*StyleBox[\\\"max\\\", \\\"TI\\\"]\) is equivalent to \
\!\(\*RowBox[{\\\"{\\\", RowBox[{\\\"0\\\", \\\",\\\", StyleBox[\\\"max\\\", \
\\\"TI\\\"]}], \\\"}\\\"}]\). \"\>", "MSG"], "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Random"]}]], "Print", "PrintUsage",
 CellChangeTimes->{3.583663582422593*^9},
 CellTags->"Info3583688782-1507343"]
}, Open  ]],

Cell["\<\
\:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19\:0e40\:0e01\:0e35\:0e48\:0e22\
\:0e27\:0e01\:0e31\:0e1a\:0e2d\:0e19\:0e38\:0e01\:0e23\:0e21\:0e01\:0e47\:0e21\
\:0e35 \:0e04\:0e38\:0e13\:0e04\:0e27\:0e23\:0e17\:0e14\:0e25\:0e2d\:0e07\
\:0e01\:0e14 ?Sum ?Product \:0e40\:0e1e\:0e37\:0e48\:0e2d\:0e14\:0e39\:0e02\
\:0e49\:0e2d\:0e21\:0e39\:0e25\:0e40\:0e1e\:0e34\:0e48\:0e21\:0e40\:0e15\:0e34\
\:0e21\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{"k", ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "N"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "N", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "N"}], ")"}]}]], "Output",
 CellChangeTimes->{3.5836628407794123`*^9, 3.583662991857666*^9, 
  3.58366358264751*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"k", "^", "2"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "N"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", "N", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "N"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "N"}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.5836628408261423`*^9, 3.583662991916503*^9, 
  3.58366358271671*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "^", "k"}], "/", 
    RowBox[{"k", "!"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 FractionBox["1", "\[ExponentialE]"]], "Output",
 CellChangeTimes->{3.583662841039489*^9, 3.583662991979033*^9, 
  3.583663582783098*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"k", "/", 
    RowBox[{"(", 
     RowBox[{"k", "+", "1"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "N"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", "N"}]]], "Output",
 CellChangeTimes->{3.5836628410747757`*^9, 3.583662992067933*^9, 
  3.583663582850005*^9}]
}, Open  ]],

Cell["\<\
\:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19\:0e40\:0e01\:0e35\:0e48\:0e22\
\:0e27\:0e01\:0e31\:0e1a Calculus \:0e01\:0e47\:0e21\:0e35 \:0e04\:0e38\:0e13\
\:0e04\:0e27\:0e23\:0e17\:0e14\:0e25\:0e2d\:0e07\:0e01\:0e14 ? \:0e2b\:0e23\
\:0e37\:0e2d\:0e14\:0e39\:0e43\:0e19 Help/Master Index \:0e40\:0e1e\:0e37\
\:0e48\:0e2d\:0e14\:0e39\:0e02\:0e49\:0e2d\:0e21\:0e39\:0e25\:0e40\:0e1e\:0e34\
\:0e48\:0e21\:0e40\:0e15\:0e34\:0e21

D = differentiation\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"2", " ", "x"}]], "Output",
 CellChangeTimes->{3.583662841129669*^9, 3.583662992170454*^9, 
  3.5836635829952*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData["2"], "Output",
 CellChangeTimes->{3.583662841175548*^9, 3.583662992270692*^9, 
  3.583663583055715*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"g", "[", "x", "]"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["g", "\[Prime]",
   MultilineFunction->None], "[", "x", "]"}]], "Output",
 CellChangeTimes->{3.583662841229764*^9, 3.583662992312821*^9, 
  3.583663583116324*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"g", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["g", 
   TagBox[
    RowBox[{"(", "3", ")"}],
    Derivative],
   MultilineFunction->None], "[", "x", "]"}]], "Output",
 CellChangeTimes->{3.5836628412757874`*^9, 3.583662992366516*^9, 
  3.583663583182909*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "D"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"D\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"f\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"x\\\", \
\\\"TI\\\"]}], \\\"]\\\"}]\) gives the partial derivative \!\(\*RowBox[{\\\"\
\[PartialD]\\\", StyleBox[\\\"f\\\", \\\"TI\\\"], \\\"/\\\", \
\\\"\[PartialD]\\\", StyleBox[\\\"x\\\", \\\"TI\\\"]}]\). \\n\!\(\*RowBox[{\\\
\"D\\\", \\\"[\\\", RowBox[{StyleBox[\\\"f\\\", \\\"TI\\\"], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{StyleBox[\\\"x\\\", \\\"TI\\\"], \\\",\\\", \
StyleBox[\\\"n\\\", \\\"TI\\\"]}], \\\"}\\\"}]}], \\\"]\\\"}]\) gives the \
multiple derivative \!\(\*RowBox[{SuperscriptBox[\\\"\[PartialD]\\\", \
StyleBox[\\\"n\\\", \\\"TI\\\"]], StyleBox[\\\"f\\\", \\\"TI\\\"], \\\"/\\\", \
\\\"\[PartialD]\\\", SuperscriptBox[StyleBox[\\\"x\\\", \\\"TI\\\"], \
StyleBox[\\\"n\\\", \\\"TI\\\"]]}]\). \\n\!\(\*RowBox[{\\\"D\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"f\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"x\\\", \
\\\"TI\\\"], \\\",\\\", StyleBox[\\\"y\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\
\\\"\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"]\\\"}]\) differentiates \
\!\(\*StyleBox[\\\"f\\\", \\\"TI\\\"]\) successively with respect to \
\!\(\*RowBox[{StyleBox[\\\"x\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"y\\\", \
\\\"TI\\\"], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\"TR\\\"]}]\).\\n\!\(\
\*RowBox[{\\\"D\\\", \\\"[\\\", RowBox[{StyleBox[\\\"f\\\", \\\"TI\\\"], \
\\\",\\\", RowBox[{\\\"{\\\", RowBox[{\\\"{\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"x\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \
\\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"x\\\", \\\"TI\\\"], \
StyleBox[\\\"2\\\", \\\"TR\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\
\"TR\\\"]}], \\\"}\\\"}], \\\"}\\\"}]}], \\\"]\\\"}]\) for a scalar \
\!\(\*StyleBox[\\\"f\\\", \\\"TI\\\"]\) gives the vector derivative \
\!\(\*RowBox[{\\\"(\\\", RowBox[{RowBox[{\\\"\[PartialD]\\\", \
RowBox[{StyleBox[\\\"f\\\", \\\"TI\\\"], \\\"/\\\", RowBox[{\\\"\[PartialD]\\\
\", SubscriptBox[StyleBox[\\\"x\\\", \\\"TI\\\"], \\\"1\\\"]}]}]}], \
\\\",\\\", RowBox[{\\\"\[PartialD]\\\", RowBox[{StyleBox[\\\"f\\\", \
\\\"TI\\\"], \\\"/\\\", RowBox[{\\\"\[PartialD]\\\", SubscriptBox[StyleBox[\\\
\"x\\\", \\\"TI\\\"], \\\"2\\\"]}]}]}], \\\",\\\", \\\"\[Ellipsis]\\\"}], \
\\\")\\\"}]\). \\n\!\(\*RowBox[{\\\"D\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"f\\\", \\\"TI\\\"], \\\",\\\", RowBox[{\\\"{\\\", \
StyleBox[\\\"array\\\", \\\"TI\\\"], \\\"}\\\"}]}], \\\"]\\\"}]\) gives a \
tensor derivative.\"\>", "MSG"], "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]}]], "Print", "PrintUsage",
 CellChangeTimes->{3.5836635838262587`*^9},
 CellTags->"Info3583688783-1507343"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"y", "^", "2"}]}], " ", "+", " ", 
    RowBox[{"c", " ", "x", " ", "y"}]}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "a", " ", "x"}], "+", 
  RowBox[{"c", " ", "y"}]}]], "Output",
 CellChangeTimes->{3.583662841780068*^9, 3.583662992716848*^9, 
  3.583663584039426*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"y", "^", "2"}]}], " ", "+", " ", 
    RowBox[{"c", " ", "x", " ", "y"}]}], ",", "x", ",", "y"}], "]"}]], "Input"],

Cell[BoxData["c"], "Output",
 CellChangeTimes->{3.583662841867186*^9, 3.583662992762742*^9, 
  3.5836635840783043`*^9}]
}, Open  ]],

Cell["Integrate = \
\:0e01\:0e32\:0e23\:0e2d\:0e34\:0e19\:0e17\:0e35\:0e40\:0e01\:0e23\:0e17", \
"Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Integrate"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"Integrate\\\", \\\"[\\\", RowBox[{StyleBox[\
\\\"f\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"x\\\", \\\"TI\\\"]}], \\\"]\\\
\"}]\) gives the indefinite integral \!\(\*RowBox[{\\\"\[Integral]\\\", \
StyleBox[\\\"f\\\", \\\"TI\\\"], \\\" \\\", StyleBox[\\\"d\\\", \\\"TI\\\"], \
StyleBox[\\\"x\\\", \\\"TI\\\"]}]\). \\n\!\(\*RowBox[{\\\"Integrate\\\", \
\\\"[\\\", RowBox[{StyleBox[\\\"f\\\", \\\"TI\\\"], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{StyleBox[\\\"x\\\", \\\"TI\\\"], \\\",\\\", \
SubscriptBox[StyleBox[\\\"x\\\", \\\"TI\\\"], StyleBox[\\\"min\\\", \
\\\"TI\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"x\\\", \\\"TI\\\"], \
StyleBox[\\\"max\\\", \\\"TI\\\"]]}], \\\"}\\\"}]}], \\\"]\\\"}]\) gives the \
definite integral \!\(\*RowBox[{SubsuperscriptBox[\\\"\[Integral]\\\", \
SubscriptBox[StyleBox[\\\"x\\\", \\\"TI\\\"], StyleBox[\\\"min\\\", \
\\\"TI\\\"]], SubscriptBox[StyleBox[\\\"x\\\", \\\"TI\\\"], \
StyleBox[\\\"max\\\", \\\"TI\\\"]]], \\\" \\\", StyleBox[\\\"f\\\", \
\\\"TI\\\"], \\\" \\\", StyleBox[\\\"d\\\", \\\"TI\\\"], StyleBox[\\\"x\\\", \
\\\"TI\\\"]}]\). \\n\!\(\*RowBox[{\\\"Integrate\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"f\\\", \\\"TI\\\"], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{StyleBox[\\\"x\\\", \\\"TI\\\"], \\\",\\\", \
SubscriptBox[StyleBox[\\\"x\\\", \\\"TI\\\"], StyleBox[\\\"min\\\", \
\\\"TI\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"x\\\", \\\"TI\\\"], \
StyleBox[\\\"max\\\", \\\"TI\\\"]]}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\
\", RowBox[{StyleBox[\\\"y\\\", \\\"TI\\\"], \\\",\\\", \
SubscriptBox[StyleBox[\\\"y\\\", \\\"TI\\\"], StyleBox[\\\"min\\\", \
\\\"TI\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"y\\\", \\\"TI\\\"], \
StyleBox[\\\"max\\\", \\\"TI\\\"]]}], \\\"}\\\"}], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"]\\\"}]\) gives the multiple integral \
\!\(\*RowBox[{SubsuperscriptBox[\\\"\[Integral]\\\", SubscriptBox[StyleBox[\\\
\"x\\\", \\\"TI\\\"], StyleBox[\\\"min\\\", \\\"TI\\\"]], \
SubscriptBox[StyleBox[\\\"x\\\", \\\"TI\\\"], StyleBox[\\\"max\\\", \
\\\"TI\\\"]]], RowBox[{StyleBox[\\\"d\\\", \\\"TI\\\"], StyleBox[\\\"x\\\", \
\\\"TI\\\"], RowBox[{SubsuperscriptBox[\\\"\[Integral]\\\", \
SubscriptBox[StyleBox[\\\"y\\\", \\\"TI\\\"], StyleBox[\\\"min\\\", \
\\\"TI\\\"]], SubscriptBox[StyleBox[\\\"y\\\", \\\"TI\\\"], \
StyleBox[\\\"max\\\", \\\"TI\\\"]]], RowBox[{StyleBox[\\\"d\\\", \\\"TI\\\"], \
\\\"\[InvisibleSpace]\\\", StyleBox[\\\"y\\\", \\\"TI\\\"], \\\" \\\", \\\"\
\[Ellipsis]\\\", \\\" \\\", StyleBox[\\\"f\\\", \\\"TI\\\"]}]}]}]}]\). \"\>", 
   "MSG"], "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]}]], "Print", "PrintUsage",
 CellChangeTimes->{3.583663584245718*^9},
 CellTags->"Info3583688784-1507343"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"g", "[", "x", "]"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"g", "[", "x", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellChangeTimes->{3.583662842316543*^9, 3.583662993179406*^9, 
  3.583663584407398*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", "a"}], " ", "x"}], "]"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "a"}], " ", "x"}]], "a"]}]], "Output",
 CellChangeTimes->{3.583662842359192*^9, 3.583662993213112*^9, 
  3.58366358444419*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", "2"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"2", " ", 
       RowBox[{"\[Sigma]", "^", "2"}]}], ")"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"ConditionalExpression", "[", 
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{"2", " ", "\[Pi]"}]], 
    SqrtBox[
     FractionBox["1", 
      SuperscriptBox["\[Sigma]", "2"]]]], ",", 
   RowBox[{
    RowBox[{"Re", "[", 
     FractionBox["1", 
      SuperscriptBox["\[Sigma]", "2"]], "]"}], ">", "0"}]}], "]"}]], "Output",
 CellChangeTimes->{3.583662844184454*^9, 3.583662994225374*^9, 
  3.583663585661666*^9}]
}, Open  ]],

Cell[TextData[{
 "\:0e02\:0e49\:0e32\:0e07\:0e1a\:0e19\:0e2d\:0e48\:0e32\:0e19\:0e27\:0e48\
\:0e32 \"\:0e16\:0e49\:0e32 real part \:0e02\:0e2d\:0e07 ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Sigma]", "2"], TraditionalForm]]],
 "\:0e40\:0e1b\:0e47\:0e19\:0e1a\:0e27\:0e01 \:0e41\:0e25\:0e49\:0e27 \:0e04\
\:0e33\:0e15\:0e2d\:0e1a\:0e04\:0e37\:0e2d ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"2", 
     SuperscriptBox["\[Pi]\[Sigma]", "2"]}]], TraditionalForm]]],
 "  \:0e21\:0e34\:0e09\:0e30\:0e19\:0e31\:0e49\:0e19 \:0e04\:0e33\:0e15\:0e2d\
\:0e1a\:0e01\:0e47\:0e15\:0e34\:0e14\:0e44\:0e27\:0e49\:0e43\:0e19\:0e23\:0e39\
\:0e1b \:0e17\:0e35\:0e48 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \:0e04\:0e34\:0e14\:0e44\:0e21\:0e48\:0e2d\:0e2d\:0e01\"\n\n\:0e16\:0e49\
\:0e32\:0e40\:0e23\:0e32\:0e23\:0e39\:0e49\:0e27\:0e48\:0e32 \[Sigma] \:0e21\
\:0e32\:0e01\:0e01\:0e27\:0e48\:0e32 0 \:0e40\:0e23\:0e32\:0e2a\:0e32\:0e21\
\:0e32\:0e23\:0e16\:0e43\:0e0a\:0e49\:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\
\:0e19 Assuming[ ] \:0e40\:0e1e\:0e37\:0e48\:0e2d\:0e0a\:0e48\:0e27\:0e22 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"\[Sigma]", ">", "0"}], ",", " ", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"x", "^", "2"}]}], "/", 
       RowBox[{"(", 
        RowBox[{"2", " ", 
         RowBox[{"\[Sigma]", "^", "2"}]}], ")"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]], " ", "\[Sigma]"}]], "Output",
 CellChangeTimes->{3.583662844817231*^9, 3.583662994355954*^9, 
  3.5836635859771147`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
\:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19\:0e01\:0e33\:0e2b\:0e19\:0e14\
\:0e40\:0e2d\:0e07 (User-defined Functions)\
\>", "Subsection"],

Cell["\<\
\:0e16\:0e49\:0e32\:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19\:0e1e\:0e23\
\:0e49\:0e2d\:0e21\:0e43\:0e0a\:0e49\:0e44\:0e21\:0e48\:0e40\:0e2b\:0e21\:0e32\
\:0e30\:0e01\:0e31\:0e1a\:0e1b\:0e31\:0e0d\:0e2b\:0e32\:0e02\:0e2d\:0e07\:0e40\
\:0e23\:0e32 \:0e40\:0e23\:0e32\:0e01\:0e47\:0e2a\:0e32\:0e21\:0e32\:0e23\
\:0e16\:0e01\:0e33\:0e2b\:0e19\:0e14\:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\
\:0e19\:0e40\:0e1e\:0e37\:0e48\:0e2d\:0e43\:0e0a\:0e49\:0e40\:0e2d\:0e07
\:0e40\:0e0a\:0e48\:0e19\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], " ", ":=", " ", 
  RowBox[{"x", "^", "2"}]}]], "Input"],

Cell[TextData[{
 "\:0e15\:0e2d\:0e19\:0e19\:0e35\:0e49 f \:0e04\:0e37\:0e2d\:0e1f\:0e31\:0e07\
\:0e04\:0e4c\:0e0a\:0e31\:0e19\:0e17\:0e35\:0e48\:0e2b\:0e32\:0e01\:0e33\:0e25\
\:0e31\:0e07\:0e2a\:0e2d\:0e07\:0e02\:0e2d\:0e07 argument  \n\:0e2a\:0e34\
\:0e48\:0e07\:0e17\:0e35\:0e48\:0e2a\:0e33\:0e04\:0e31\:0e0d\:0e04\:0e37\:0e2d\
\:0e40\:0e04\:0e23\:0e37\:0e48\:0e2d\:0e07\:0e2b\:0e21\:0e32\:0e22 _ \:0e41\
\:0e25\:0e30 :=\n\n\:0e40\:0e04\:0e23\:0e37\:0e48\:0e2d\:0e07\:0e2b\:0e21\
\:0e32\:0e22  _ \:0e2d\:0e48\:0e32\:0e19\:0e27\:0e48\:0e32 blank\n\
\:0e15\:0e2d\:0e19\:0e19\:0e35\:0e49\:0e02\:0e2d\:0e43\:0e2b\:0e49\:0e08\:0e33\
\:0e44\:0e27\:0e49\:0e27\:0e48\:0e32 argument \:0e17\:0e32\:0e07\:0e14\:0e49\
\:0e32\:0e19\:0e0b\:0e49\:0e32\:0e22\:0e02\:0e2d\:0e07\:0e1f\:0e31\:0e07\:0e04\
\:0e4c\:0e0a\:0e31\:0e19\:0e15\:0e49\:0e2d\:0e07\:0e21\:0e35\:0e40\:0e04\:0e23\
\:0e37\:0e48\:0e2d\:0e07\:0e2b\:0e21\:0e32\:0e22 _ \:0e15\:0e48\:0e2d\:0e17\
\:0e49\:0e32\:0e22\:0e40\:0e2a\:0e21\:0e2d  \:0e40\:0e2b\:0e15\:0e38\:0e1c\
\:0e25\:0e08\:0e30\:0e21\:0e32\:0e1a\:0e2d\:0e01\:0e43\:0e19\:0e15\:0e2d\:0e19\
\:0e15\:0e48\:0e2d\:0e46\:0e44\:0e1b (\:0e41\:0e15\:0e48\:0e16\:0e49\:0e32\
\:0e04\:0e38\:0e13\:0e2d\:0e22\:0e32\:0e01\:0e23\:0e39\:0e49\:0e08\:0e23\:0e34\
\:0e07\:0e46\:0e25\:0e2d\:0e07\:0e2b\:0e32\:0e14\:0e39\:0e43\:0e19 Help \
\:0e01\:0e47\:0e44\:0e14\:0e49 \:0e40\:0e01\:0e35\:0e48\:0e22\:0e27\:0e01\
\:0e31\:0e1a pattern matching)\n\n\:0e40\:0e04\:0e23\:0e37\:0e48\:0e2d\:0e07\
\:0e2b\:0e21\:0e32\:0e22 := \:0e2d\:0e48\:0e32\:0e19\:0e27\:0e48\:0e32 \
delayed-assign \:0e2b\:0e23\:0e37\:0e2d SetDelayed \n\:0e2b\:0e21\:0e32\:0e22\
\:0e04\:0e27\:0e32\:0e21\:0e27\:0e48\:0e32\:0e01\:0e32\:0e23\:0e41\:0e17\:0e19\
\:0e04\:0e48\:0e32 f[x] \
\:0e08\:0e30\:0e40\:0e01\:0e34\:0e14\:0e02\:0e36\:0e49\:0e19\:0e40\:0e21\:0e37\
\:0e48\:0e2d f[x] \:0e16\:0e39\:0e01\:0e43\:0e0a\:0e49 \:0e21\:0e34\:0e43\
\:0e0a\:0e48\:0e15\:0e2d\:0e19\:0e01\:0e33\:0e2b\:0e19\:0e14 f[x] \
\:0e15\:0e2d\:0e19\:0e19\:0e35\:0e49\:0e43\:0e2b\:0e49\:0e08\:0e33\:0e44\:0e1b\
\:0e01\:0e48\:0e2d\:0e19\:0e27\:0e48\:0e32\:0e16\:0e49\:0e32\:0e08\:0e30\:0e01\
\:0e33\:0e2b\:0e19\:0e14\:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19\:0e40\
\:0e2d\:0e07\:0e43\:0e2b\:0e49\:0e43\:0e0a\:0e49 :=\n\n\:0e0a\:0e37\:0e48\
\:0e2d\:0e02\:0e2d\:0e07\:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19\:0e08\
\:0e30\:0e02\:0e36\:0e49\:0e19\:0e15\:0e49\:0e19\:0e14\:0e49\:0e27\:0e22\:0e15\
\:0e31\:0e27\:0e40\:0e25\:0e02\:0e44\:0e21\:0e48\:0e44\:0e14\:0e49 \:0e41\
\:0e25\:0e30\:0e21\:0e35 _ \:0e43\:0e19\:0e0a\:0e37\:0e48\:0e2d\:0e44\:0e21\
\:0e48\:0e44\:0e14\:0e49\n\n\:0e1b\:0e01\:0e15\:0e34\:0e40\:0e23\:0e32\:0e08\
\:0e30\:0e15\:0e31\:0e49\:0e07\:0e0a\:0e37\:0e48\:0e2d\:0e1f\:0e31\:0e07\:0e04\
\:0e4c\:0e0a\:0e31\:0e19\:0e17\:0e35\:0e48\:0e40\:0e23\:0e32\:0e01\:0e33\:0e2b\
\:0e19\:0e14\:0e14\:0e49\:0e27\:0e22\:0e2d\:0e31\:0e01\:0e29\:0e23\:0e15\:0e31\
\:0e27\:0e40\:0e25\:0e47\:0e01\:0e08\:0e30\:0e44\:0e14\:0e49\:0e44\:0e21\:0e48\
\:0e2a\:0e31\:0e1a\:0e2a\:0e19\:0e01\:0e31\:0e1a\:0e1f\:0e31\:0e07\:0e04\:0e4c\
\:0e0a\:0e31\:0e19\:0e02\:0e2d\:0e07 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \:0e40\:0e2d\:0e07"
}], "Text"],

Cell["\<\
\:0e2b\:0e25\:0e31\:0e07\:0e08\:0e32\:0e01\:0e17\:0e35\:0e48\:0e40\:0e23\:0e32\
\:0e01\:0e33\:0e2b\:0e19\:0e14\:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19\
 f \:0e40\:0e23\:0e32\:0e01\:0e47\:0e2a\:0e32\:0e21\:0e32\:0e23\:0e16\:0e43\
\:0e0a\:0e49\:0e21\:0e31\:0e19\:0e43\:0e19\:0e01\:0e32\:0e23\:0e04\:0e33\:0e19\
\:0e27\:0e19\:0e15\:0e48\:0e32\:0e07\:0e46\:0e44\:0e14\:0e49\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "a", "]"}]], "Input"],

Cell[BoxData[
 SuperscriptBox["a", "2"]], "Output",
 CellChangeTimes->{3.58366284491051*^9, 3.583662994414523*^9, 
  3.583663586025391*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "2", "]"}]], "Input"],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.583662844975647*^9, 3.583662994463438*^9, 
  3.583663586063594*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"f", "[", "k", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "N"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", "N", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "N"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "N"}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.58366284504307*^9, 3.583662994515419*^9, 
  3.583663586095146*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["x", "3"], "3"]], "Output",
 CellChangeTimes->{3.583662845113511*^9, 3.583662994563072*^9, 
  3.583663586146912*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "\[Alpha]", ",", "\[Beta]"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["\[Alpha]", "3"], "3"]}], "+", 
  FractionBox[
   SuperscriptBox["\[Beta]", "3"], "3"]}]], "Output",
 CellChangeTimes->{3.5836628451804543`*^9, 3.583662994670773*^9, 
  3.583663586195107*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw1mOc71n3cgO3NhZu6FTJKVlYoFZ+fkqQQmZFVKEqyZYaErJAdslUuO9vX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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{-2, 2}, {0., 3.9999996734693943`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.5836628452516603`*^9, 3.5836629948379*^9, 
  3.583663586253889*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"Exp", "[", 
      RowBox[{"-", 
       RowBox[{"f", "[", "x", "]"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw1mOc71n3cgO3NhZu6FTJKVlYoFZ+fkqQQmZFVKEqyZYaErJAdslUuO9vX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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJw12Hk0VV/YB3CzUuYoYyKKZEqm6MGv2RBKyZBSKUOSpJQyJEUDmclMZhe5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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{-2, 2}, {0., 3.9999996734693943`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.583662845837111*^9, 3.5836629949649153`*^9, 
  3.583663586276067*^9}]
}, Open  ]],

Cell["\<\
\:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19\:0e2d\:0e32\:0e08\:0e21\:0e35\
 argument \:0e21\:0e32\:0e01\:0e01\:0e27\:0e48\:0e32 \:0e2b\:0e19\:0e36\:0e48\
\:0e07\:0e15\:0e31\:0e27\:0e40\:0e0a\:0e48\:0e19\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f2", "[", 
   RowBox[{"x_", ",", "y_", ",", "d_"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"2", 
     RowBox[{"d", "^", "2"}]}], ")"}]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f2", "[", 
  RowBox[{"x", ",", "y", ",", "d"}], "]"}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   SuperscriptBox["y", "2"]}], 
  RowBox[{"2", " ", 
   SuperscriptBox["d", "2"]}]]], "Output",
 CellChangeTimes->{3.583662846007039*^9, 3.583662995014509*^9, 
  3.583663586323138*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f2", "[", 
  RowBox[{"0", ",", "0", ",", "1"}], "]"}]], "Input"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.583662846063665*^9, 3.583662995082797*^9, 
  3.5836635863616953`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"f2", "[", 
      RowBox[{"x", ",", "y", ",", "1"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1nHm8zeX2x08ZEt0GbrdBmSIlGu7FaVBLcWW4TQh100CDykmTUqkbKVEq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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmXfgVuMbxt9znudIkkpbKaGQJiGVkUgiWkZpDxkJ0VBGQwkNDbQzy8hM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         "]], Polygon3DBox[CompressedData["
1:eJwtmnng1dMWxb9niApJKknRRCkaSKaemZRChgjJVIrMUyQyPUNFpchcMmSI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         "]], Polygon3DBox[CompressedData["
1:eJwt13ncVXMeB/Dnufe2aqFNq1CJNrShValQKdr3tJJWKiUlWhRFtJOSpUQL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         "]], 
        Polygon3DBox[{{970, 576, 692, 1128, 809, 810}, {1078, 589, 383, 382, 
         695, 1020}}]}]}, {}, {}, {}, {}}, {
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0rkuRGEYgOHfvm8REbHFBdARBZ1oqIiGbqKhIKKhE4nQ6aiUXAElBS5A
MLYxhohOUJCI/flRvPN8J3NyzvdPpiUxOTCRFUJY0Jfi/KZb7WaHUMkDNjPD
Nj6wm5/sZ2lOCCNsYKPGzZ2cZS+XOMRVjnKD09ziPPcZckO4D38LHOFDzzp0
fcwjJnnMEyZ5yhOe8ZTnPIvqwnzBFFO85CXTTPOKV8zEc/Ga287zEFdwfRPP
pxet2fGQy9zjHDc5xXUmuMJBLrKHM+xgu8bMdRxmMfv47l1dvGdr3IlNfPX9
Hb9VEe/TkxrtVM56lsXnsZS1LGENi1nNIlaxkOXxfhWYS5jPIuaxIOv3Zw95
9NqQQ2uEHR+P//+HHyr+Rhg=
       "]]}, {
      Line3DBox[{706, 1014, 480, 705, 1130, 926, 707, 1131, 927, 708, 1132, 
       928, 709, 1133, 929, 710, 1134, 930, 711, 1135, 1029, 1228, 712, 1136, 
       931, 713, 1137, 932, 714, 1138, 933, 715, 1139, 934, 716, 1140, 935, 
       717, 1141, 936, 718, 1328, 1015, 937, 1016}], 
      Line3DBox[{720, 1030, 1229, 719, 495, 721, 1142, 938, 722, 1143, 939, 
       723, 1144, 940, 724, 1145, 941, 725, 1146, 1031, 1230, 726, 1032, 1231,
        727, 1147, 942, 728, 1148, 943, 729, 1149, 944, 730, 1150, 945, 731, 
       1151, 946, 732, 1152, 947, 733}], 
      Line3DBox[{735, 1033, 1232, 734, 1034, 1233, 736, 511, 737, 1153, 948, 
       738, 1154, 949, 739, 1155, 950, 740, 1156, 1035, 1234, 741, 1036, 1235,
        742, 1037, 1236, 743, 519, 744, 1157, 951, 745, 1158, 952, 746, 1159, 
       953, 747, 1160, 954, 748}], 
      Line3DBox[{750, 1038, 1237, 749, 1039, 1238, 751, 1040, 1239, 752, 527, 
       753, 1161, 955, 754, 1162, 956, 755, 1163, 1041, 1240, 756, 1042, 1241,
        757, 1043, 1242, 758, 1044, 1243, 759, 535, 760, 1164, 957, 761, 1165,
        958, 762, 1166, 959, 763}], 
      Line3DBox[{765, 1045, 1244, 764, 1046, 1245, 766, 1047, 1246, 767, 1048,
        1247, 768, 543, 769, 1167, 960, 770, 1168, 1049, 1248, 771, 1050, 
       1249, 772, 1051, 1250, 773, 1052, 1251, 774, 1053, 1252, 775, 1054, 
       1253, 776, 1169, 961, 777, 1170, 962, 778}], 
      Line3DBox[{780, 1055, 1254, 779, 1056, 1255, 781, 1057, 1256, 782, 1058,
        1257, 783, 1059, 1258, 784, 559, 785, 1171, 1060, 1259, 786, 1061, 
       1260, 787, 1062, 1261, 788, 1063, 1262, 789, 1064, 1263, 790, 1065, 
       1264, 791, 567, 792, 1172, 963, 793}], 
      Line3DBox[{797, 1173, 964, 795, 1174, 965, 799, 1175, 966, 801, 1176, 
       967, 803, 1177, 968, 805, 1178, 969, 807, 1127, 1179, 1027, 575, 1026, 
       1019, 1028, 1332, 970, 810, 1180, 971, 812, 1181, 972, 814, 1182, 973, 
       816, 1183, 974, 818, 1184, 975, 820, 1186, 977, 822}], 
      Line3DBox[{821, 976, 1185, 819, 1276, 1076, 817, 1275, 1075, 815, 1274, 
       1074, 813, 1273, 1073, 811, 1272, 1072, 809, 1128, 1271, 1018, 808, 
       1331, 1017, 689, 806, 1270, 1071, 804, 1269, 1070, 802, 1268, 1069, 
       800, 1267, 1068, 798, 1266, 1067, 794, 1265, 1066, 796}], 
      Line3DBox[{824, 1077, 1277, 823, 1187, 978, 825, 1188, 979, 826, 1189, 
       980, 827, 1190, 981, 828, 1191, 982, 829, 1330, 1020, 1078, 1329, 1022,
        1021, 590, 830, 1192, 983, 831, 1193, 984, 832, 1194, 985, 833, 1195, 
       986, 834, 1196, 987, 835, 1197, 988, 836}], 
      Line3DBox[{838, 1079, 1278, 837, 1080, 1279, 839, 1198, 989, 840, 1199, 
       990, 841, 1200, 991, 842, 1201, 992, 843, 1202, 1081, 1280, 844, 1082, 
       1281, 845, 606, 846, 1203, 993, 847, 1204, 994, 848, 1205, 995, 849, 
       1206, 996, 850, 1207, 997, 851}], 
      Line3DBox[{853, 1083, 1282, 852, 1084, 1283, 854, 614, 855, 1208, 998, 
       856, 1209, 999, 857, 1210, 1000, 858, 1211, 1085, 1284, 859, 1086, 
       1285, 860, 1087, 1286, 861, 622, 862, 1212, 1001, 863, 1213, 1002, 864,
        1214, 1003, 865, 1215, 1004, 866}], 
      Line3DBox[{868, 1088, 1287, 867, 1089, 1288, 869, 1090, 1289, 870, 630, 
       871, 1216, 1005, 872, 1217, 1006, 873, 1218, 1091, 1290, 874, 1092, 
       1291, 875, 1093, 1292, 876, 1094, 1293, 877, 638, 878, 1219, 1007, 879,
        1220, 1008, 880, 1221, 1009, 881}], 
      Line3DBox[{883, 1095, 1294, 882, 1096, 1295, 884, 1097, 1296, 885, 1098,
        1297, 886, 646, 887, 1222, 1010, 888, 1223, 1099, 1298, 889, 1100, 
       1299, 890, 1101, 1300, 891, 1102, 1301, 892, 1103, 1302, 893, 654, 894,
        1224, 1011, 895, 1225, 1012, 896}], 
      Line3DBox[{898, 1104, 1303, 897, 1105, 1304, 899, 1106, 1305, 900, 1107,
        1306, 901, 1108, 1307, 902, 662, 903, 1226, 1109, 1308, 904, 1110, 
       1309, 905, 1111, 1310, 906, 1112, 1311, 907, 1113, 1312, 908, 1114, 
       1313, 909, 670, 910, 1227, 1013, 911}], 
      Line3DBox[{925, 1025, 699, 924, 1327, 1126, 923, 1326, 1125, 922, 1325, 
       1124, 921, 1324, 1123, 920, 1323, 1122, 919, 1322, 1121, 918, 1321, 
       1320, 1120, 917, 1319, 1119, 916, 1318, 1118, 915, 1317, 1117, 914, 
       1316, 1116, 913, 1315, 1115, 912, 1129, 1314, 1023, 1024}]}, {
      Line3DBox[{259, 481, 1130, 260, 495, 288, 1233, 510, 303, 1238, 525, 
       318, 1245, 540, 333, 1255, 555, 348, 1266, 570, 1174, 363, 584, 1187, 
       377, 1279, 598, 392, 1283, 613, 407, 1288, 628, 422, 1295, 643, 437, 
       1304, 658, 452, 1315, 673, 467}], 
      Line3DBox[{261, 482, 1131, 262, 496, 1142, 289, 511, 304, 1239, 526, 
       319, 1246, 541, 334, 1256, 556, 349, 1267, 571, 1175, 364, 585, 1188, 
       378, 599, 1198, 393, 614, 408, 1289, 629, 423, 1296, 644, 438, 1305, 
       659, 453, 1316, 674, 468}], 
      Line3DBox[{263, 483, 1132, 264, 497, 1143, 290, 512, 1153, 305, 527, 
       320, 1247, 542, 335, 1257, 557, 350, 1268, 572, 1176, 365, 586, 1189, 
       379, 600, 1199, 394, 615, 1208, 409, 630, 424, 1297, 645, 439, 1306, 
       660, 454, 1317, 675, 469}], 
      Line3DBox[{265, 484, 1133, 266, 498, 1144, 291, 513, 1154, 306, 528, 
       1161, 321, 543, 336, 1258, 558, 351, 1269, 573, 1177, 366, 587, 1190, 
       380, 601, 1200, 395, 616, 1209, 410, 631, 1216, 425, 646, 440, 1307, 
       661, 455, 1318, 676, 470}], 
      Line3DBox[{267, 485, 1134, 268, 499, 1145, 292, 514, 1155, 307, 529, 
       1162, 322, 544, 1167, 337, 559, 352, 1270, 574, 1178, 367, 588, 1191, 
       381, 602, 1201, 396, 617, 1210, 411, 632, 1217, 426, 647, 1222, 441, 
       662, 456, 1319, 677, 471}], 
      Line3DBox[{269, 486, 1135, 271, 500, 1146, 293, 515, 1156, 308, 530, 
       1163, 323, 545, 1168, 338, 560, 1171, 353, 689, 691, 1179, 704, 693, 
       1330, 695, 382, 603, 1202, 397, 618, 1211, 412, 633, 1218, 427, 648, 
       1223, 442, 663, 1226, 457, 1320, 678, 472}], 
      Line3DBox[{273, 488, 1136, 274, 1231, 502, 295, 1235, 517, 310, 1241, 
       532, 325, 1249, 547, 340, 1260, 562, 355, 1271, 692, 576, 1332, 369, 
       696, 590, 384, 1281, 605, 399, 1285, 620, 414, 1291, 635, 429, 1299, 
       650, 444, 1309, 665, 459, 1322, 680, 474}], 
      Line3DBox[{275, 489, 1137, 276, 503, 1147, 296, 1236, 518, 311, 1242, 
       533, 326, 1250, 548, 341, 1261, 563, 356, 1272, 577, 1180, 370, 591, 
       1192, 385, 606, 400, 1286, 621, 415, 1292, 636, 430, 1300, 651, 445, 
       1310, 666, 460, 1323, 681, 475}], 
      Line3DBox[{277, 490, 1138, 278, 504, 1148, 297, 519, 312, 1243, 534, 
       327, 1251, 549, 342, 1262, 564, 357, 1273, 578, 1181, 371, 592, 1193, 
       386, 607, 1203, 401, 622, 416, 1293, 637, 431, 1301, 652, 446, 1311, 
       667, 461, 1324, 682, 476}], 
      Line3DBox[{279, 491, 1139, 280, 505, 1149, 298, 520, 1157, 313, 535, 
       328, 1252, 550, 343, 1263, 565, 358, 1274, 579, 1182, 372, 593, 1194, 
       387, 608, 1204, 402, 623, 1212, 417, 638, 432, 1302, 653, 447, 1312, 
       668, 462, 1325, 683, 477}], 
      Line3DBox[{281, 492, 1140, 282, 506, 1150, 299, 521, 1158, 314, 536, 
       1164, 329, 1253, 551, 344, 1264, 566, 359, 1275, 580, 1183, 373, 594, 
       1195, 388, 609, 1205, 403, 624, 1213, 418, 639, 1219, 433, 654, 448, 
       1313, 669, 463, 1326, 684, 478}], 
      Line3DBox[{283, 493, 1141, 284, 507, 1151, 300, 522, 1159, 315, 537, 
       1165, 330, 552, 1169, 345, 567, 360, 1276, 581, 1184, 374, 595, 1196, 
       389, 610, 1206, 404, 625, 1214, 419, 640, 1220, 434, 655, 1224, 449, 
       670, 464, 1327, 685, 479}], 
      Line3DBox[{285, 687, 1328, 688, 286, 508, 1152, 301, 523, 1160, 316, 
       538, 1166, 331, 553, 1170, 346, 568, 1172, 361, 582, 1185, 1186, 375, 
       596, 1197, 390, 611, 1207, 405, 626, 1215, 420, 641, 1221, 435, 656, 
       1225, 450, 671, 1227, 465, 699, 700, 701}], 
      Line3DBox[{466, 672, 698, 1314, 451, 657, 1303, 436, 642, 1294, 421, 
       627, 1287, 406, 612, 1282, 391, 597, 1278, 376, 583, 1277, 362, 1173, 
       569, 1265, 347, 554, 1254, 332, 539, 1244, 317, 524, 1237, 302, 509, 
       1232, 287, 494, 1229, 258, 480, 686, 702}], 
      Line3DBox[{473, 679, 1321, 458, 664, 1308, 443, 649, 1298, 428, 634, 
       1290, 413, 619, 1284, 398, 604, 1280, 383, 589, 1329, 697, 694, 368, 
       575, 703, 1331, 690, 354, 561, 1259, 339, 546, 1248, 324, 531, 1240, 
       309, 516, 1234, 294, 501, 1230, 272, 487, 1228, 270}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJx0XHlcztvzT3YhIbJXUtkiooRGizVS2RNSRCUqSyWyhISIZJckbVRIpYXT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    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{-2, 2}, {-2, 2}, {0., 1.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.583662846136568*^9, 3.583662995173456*^9, 
  3.5836635870775537`*^9}]
}, Open  ]],

Cell["\<\
\:0e2d\:0e35\:0e01\:0e15\:0e31\:0e27\:0e2d\:0e22\:0e48\:0e32\:0e07\:0e17\:0e35\
\:0e48\:0e43\:0e0a\:0e49\:0e04\:0e33\:0e19\:0e27\:0e13 integral \:0e02\:0e2d\
\:0e07 \:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19\:0e08\:0e32\:0e01 \
xmin \:0e16\:0e36\:0e07 xmax\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"myInt", "[", 
   RowBox[{"f_", ",", "xmin_", ",", "xmax_"}], "]"}], " ", ":=", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "xmin", ",", "xmax"}], "}"}]}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myInt", "[", 
  RowBox[{"Sin", ",", "0", ",", "L"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"Cos", "[", "L", "]"}]}]], "Output",
 CellChangeTimes->{3.5836628462841578`*^9, 3.583662995216325*^9, 
  3.583663587478301*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myInt", "[", 
  RowBox[{"f", ",", "0", ",", "a"}], "]"}]], "Input"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["a", "3"], "3"]], "Output",
 CellChangeTimes->{3.583662846653654*^9, 3.5836629952831717`*^9, 
  3.583663587533627*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myInt", "[", 
  RowBox[{"g", ",", "a", ",", "b"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "a", "b"], 
  RowBox[{
   RowBox[{"g", "[", "x", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellChangeTimes->{3.583662846693078*^9, 3.58366299551449*^9, 
  3.583663587621015*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{"x", ",", 
    RowBox[{"x", "^", "3"}]}], "]"}], "[", "2", "]"}]], "Input"],

Cell[BoxData["8"], "Output",
 CellChangeTimes->{3.5836628467429123`*^9, 3.5836629956113234`*^9, 
  3.583663587683371*^9}]
}, Open  ]],

Cell["\<\
\:0e40\:0e23\:0e32\:0e2a\:0e32\:0e21\:0e32\:0e23\:0e16\:0e43\:0e0a\:0e49 ? \
\:0e14\:0e39\:0e02\:0e49\:0e2d\:0e21\:0e39\:0e25\:0e40\:0e01\:0e35\:0e48\:0e22\
\:0e27\:0e01\:0e31\:0e1a\:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19\:0e17\
\:0e35\:0e48\:0e40\:0e23\:0e32\:0e01\:0e33\:0e2b\:0e19\:0e14\:0e40\:0e2d\:0e07\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input"],

Cell["Global`f", "Print", "PrintUsage",
 CellChangeTimes->{3.583663588221591*^9},
 CellTags->"Info3583688787-2646576"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"f", "[", "x_", "]"}], ":=", 
         SuperscriptBox["x", "2"]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`f],
  Editable->False]], "Print",
 CellChangeTimes->{3.5836635883674097`*^9},
 CellTags->"Info3583688787-2646576"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "f2"}]], "Input"],

Cell["Global`f2", "Print", "PrintUsage",
 CellChangeTimes->{3.583663588716666*^9},
 CellTags->"Info3583688788-2646576"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"f2", "[", 
          RowBox[{"x_", ",", "y_", ",", "d_"}], "]"}], ":=", 
         FractionBox[
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"]}], 
          RowBox[{"2", " ", 
           SuperscriptBox["d", "2"]}]]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`f2],
  Editable->False]], "Print",
 CellChangeTimes->{3.583663588805444*^9},
 CellTags->"Info3583688788-2646576"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "myInt"}]], "Input"],

Cell["Global`myInt", "Print", "PrintUsage",
 CellChangeTimes->{3.583663589317203*^9},
 CellTags->"Info3583688789-2646576"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"myInt", "[", 
          RowBox[{"f_", ",", "xmin_", ",", "xmax_"}], "]"}], ":=", 
         RowBox[{
          SubsuperscriptBox["\[Integral]", "xmin", "xmax"], 
          RowBox[{
           RowBox[{"f", "[", "x", "]"}], 
           RowBox[{"\[DifferentialD]", "x"}]}]}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`myInt],
  Editable->False]], "Print",
 CellChangeTimes->{3.583663589331315*^9},
 CellTags->"Info3583688789-2646576"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\:0e42\:0e21\:0e14\:0e39\:0e25 (Module)", "Subsection"],

Cell["\<\
\:0e1a\:0e32\:0e07\:0e04\:0e23\:0e31\:0e49\:0e07\:0e40\:0e27\:0e25\:0e32\:0e40\
\:0e23\:0e32\:0e01\:0e33\:0e2b\:0e19\:0e14\:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\
\:0e31\:0e19\:0e40\:0e23\:0e32\:0e15\:0e49\:0e2d\:0e07\:0e43\:0e0a\:0e49\:0e15\
\:0e31\:0e27\:0e41\:0e1b\:0e23\:0e0a\:0e31\:0e48\:0e27\:0e04\:0e23\:0e32\:0e27\
\:0e43\:0e19\:0e23\:0e30\:0e2b\:0e27\:0e48\:0e32\:0e07\:0e01\:0e32\:0e23\:0e04\
\:0e33\:0e19\:0e27\:0e13  \:0e41\:0e25\:0e30\:0e21\:0e35\:0e02\:0e31\:0e49\
\:0e19\:0e15\:0e2d\:0e19\:0e43\:0e19\:0e01\:0e32\:0e23\:0e04\:0e33\:0e19\:0e27\
\:0e13\:0e2b\:0e25\:0e32\:0e22\:0e02\:0e31\:0e49\:0e19\:0e15\:0e2d\:0e19 \
\:0e27\:0e34\:0e18\:0e35\:0e17\:0e35\:0e48\:0e40\:0e23\:0e32\:0e04\:0e27\:0e23\
\:0e43\:0e0a\:0e49\:0e04\:0e37\:0e2d Module[ ]

Module \:0e40\:0e2b\:0e21\:0e37\:0e2d\:0e19\:0e01\:0e31\:0e1a\:0e01\:0e32\
\:0e23 scope \:0e15\:0e31\:0e27\:0e41\:0e1b\:0e23 \:0e17\:0e35\:0e48\:0e16\
\:0e39\:0e01\:0e01\:0e33\:0e2b\:0e19\:0e14 (defined) \:0e43\:0e2b\:0e49\:0e40\
\:0e2b\:0e47\:0e19\:0e40\:0e09\:0e1e\:0e32\:0e30\:0e43\:0e19 Module \:0e40\
\:0e17\:0e48\:0e32\:0e19\:0e31\:0e49\:0e19 \:0e40\:0e19\:0e37\:0e48\:0e2d\
\:0e07\:0e08\:0e32\:0e01 Mathematica \:0e08\:0e30\:0e43\:0e2b\:0e49 \:0e15\
\:0e31\:0e27\:0e41\:0e1b\:0e23\:0e40\:0e1b\:0e47\:0e19 global \:0e41\:0e25\
\:0e30\:0e40\:0e2b\:0e47\:0e19\:0e44\:0e14\:0e49\:0e17\:0e38\:0e01\:0e41\:0e2b\
\:0e48\:0e07\:0e16\:0e49\:0e32\:0e40\:0e23\:0e32\:0e44\:0e21\:0e48\:0e1a\:0e2d\
\:0e01\:0e43\:0e2b\:0e49 Mathematica \:0e23\:0e39\:0e49\:0e27\:0e48\:0e32\
\:0e15\:0e31\:0e27\:0e41\:0e1b\:0e23\:0e04\:0e27\:0e23\:0e08\:0e30\:0e40\:0e1b\
\:0e47\:0e19 local variables \:0e14\:0e49\:0e27\:0e22\:0e04\:0e33\:0e2a\:0e31\
\:0e48\:0e07 Module[{localvar1, localvar2, ...}, expression1; expression2; \
expression3;...;expressionN]

localvar1, localvar2, ... \:0e04\:0e37\:0e2d\:0e15\:0e31\:0e27\:0e41\:0e1b\
\:0e23\:0e0a\:0e31\:0e48\:0e27\:0e04\:0e23\:0e32\:0e27

expression1; expression2;...;expressionN \:0e04\:0e37\:0e2d\:0e0a\:0e38\:0e14\
\:0e04\:0e33\:0e2a\:0e31\:0e48\:0e07\:0e17\:0e35\:0e48\:0e21\:0e32\:0e17\:0e33\
\:0e07\:0e32\:0e19\:0e15\:0e48\:0e2d\:0e46\:0e01\:0e31\:0e19  \:0e40\:0e04\
\:0e23\:0e37\:0e48\:0e2d\:0e07\:0e2b\:0e21\:0e32\:0e22 \";\" \:0e08\:0e33\
\:0e40\:0e1b\:0e47\:0e19\:0e08\:0e30\:0e15\:0e49\:0e2d\:0e07\:0e21\:0e35\:0e2b\
\:0e25\:0e31\:0e07\:0e17\:0e38\:0e01\:0e04\:0e33\:0e2a\:0e31\:0e48\:0e07\:0e20\
\:0e32\:0e22\:0e43\:0e19 Module \:0e22\:0e01\:0e40\:0e27\:0e49\:0e19\:0e04\
\:0e33\:0e2a\:0e31\:0e48\:0e07\:0e2a\:0e38\:0e14\:0e17\:0e49\:0e32\:0e22 \
\:0e0b\:0e36\:0e48\:0e07\:0e08\:0e30\:0e21\:0e35\:0e2b\:0e23\:0e37\:0e2d\:0e44\
\:0e21\:0e48\:0e01\:0e47\:0e44\:0e14\:0e49 \:0e42\:0e14\:0e22\:0e1b\:0e01\
\:0e15\:0e34\:0e04\:0e33\:0e2a\:0e31\:0e48\:0e07\:0e2a\:0e38\:0e14\:0e17\:0e49\
\:0e32\:0e22\:0e08\:0e30\:0e44\:0e21\:0e48\:0e21\:0e35 \";\" \:0e15\:0e48\
\:0e2d\:0e17\:0e49\:0e32\:0e22 \:0e0b\:0e36\:0e48\:0e07\:0e41\:0e1b\:0e25\
\:0e27\:0e48\:0e32\:0e1c\:0e25\:0e25\:0e31\:0e1e\:0e17\:0e4c\:0e02\:0e2d\:0e07\
\:0e04\:0e33\:0e2a\:0e31\:0e48\:0e07\:0e2a\:0e38\:0e14\:0e17\:0e49\:0e32\:0e22\
\:0e04\:0e37\:0e2d\:0e04\:0e48\:0e32\:0e17\:0e35\:0e48\:0e1f\:0e31\:0e07\:0e04\
\:0e4c\:0e0a\:0e31\:0e19\:0e08\:0e30\:0e2a\:0e48\:0e07\:0e01\:0e25\:0e31\:0e1a\
\:0e44\:0e1b\:0e43\:0e2b\:0e49\:0e1c\:0e39\:0e49\:0e40\:0e23\:0e35\:0e22\:0e01\
\:0e43\:0e0a\:0e49\:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19\:0e19\:0e31\
\:0e49\:0e19\:0e46 \:0e16\:0e49\:0e32\:0e04\:0e33\:0e2a\:0e31\:0e48\:0e07\
\:0e2a\:0e38\:0e14\:0e17\:0e49\:0e32\:0e22\:0e21\:0e35 \";\" \:0e15\:0e48\
\:0e2d\:0e17\:0e49\:0e32\:0e22 \:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\
\:0e19\:0e01\:0e47\:0e08\:0e30\:0e44\:0e21\:0e48\:0e2a\:0e48\:0e07\:0e04\:0e48\
\:0e32\:0e43\:0e14\:0e46\:0e01\:0e25\:0e31\:0e1a

\:0e04\:0e31\:0e27\:0e2d\:0e22\:0e48\:0e32\:0e07\:0e41\:0e23\:0e01 \:0e40\
\:0e23\:0e32\:0e08\:0e30\:0e2a\:0e23\:0e49\:0e32\:0e07 \:0e1f\:0e31\:0e07\
\:0e04\:0e4c\:0e0a\:0e31\:0e19 myCircleArea[ ] \:0e17\:0e35\:0e48\:0e08\:0e30\
\:0e23\:0e31\:0e1a\:0e04\:0e48\:0e32 diameter (\:0e40\:0e2a\:0e49\:0e19\:0e1c\
\:0e48\:0e32\:0e28\:0e39\:0e19\:0e22\:0e4c\:0e01\:0e25\:0e32\:0e07) \:0e41\
\:0e25\:0e49\:0e27\:0e04\:0e33\:0e19\:0e27\:0e13 \:0e1e\:0e37\:0e49\:0e19\
\:0e17\:0e35\:0e48\:0e2d\:0e2d\:0e01\:0e21\:0e32
\:0e23\:0e30\:0e2b\:0e27\:0e48\:0e32\:0e07\:0e01\:0e32\:0e23\:0e04\:0e33\:0e19\
\:0e27\:0e13 myCircleArea \:0e08\:0e30\:0e43\:0e0a\:0e49\:0e15\:0e31\:0e27\
\:0e41\:0e1b\:0e23\:0e0a\:0e31\:0e48\:0e27\:0e04\:0e23\:0e32\:0e27\:0e0a\:0e37\
\:0e48\:0e2d radius (\:0e23\:0e31\:0e28\:0e21\:0e35) \:0e41\:0e25\:0e30 area \
(\:0e1e\:0e37\:0e49\:0e19\:0e17\:0e35\:0e48)\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"myCircleArea", "[", "diameter_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"radius", ",", "area"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"radius", " ", "=", " ", 
      RowBox[{"diameter", "/", "2"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"area", " ", "=", " ", 
      RowBox[{"Pi", " ", 
       RowBox[{"radius", "^", "2"}]}]}], ";", "\[IndentingNewLine]", 
     "area"}]}], "]"}]}]], "Input"],

Cell[TextData[{
 "\:0e2a\:0e48\:0e27\:0e19 {radius, area} \:0e43\:0e19 \
myCircleArea[diameter_]:=Module[{radius,area},... \:0e04\:0e37\:0e2d\:0e01\
\:0e32\:0e23\:0e1b\:0e23\:0e30\:0e01\:0e32\:0e28\:0e27\:0e48\:0e32\:0e1f\:0e31\
\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19 myCircleArea \:0e08\:0e30\:0e43\:0e0a\
\:0e49\:0e15\:0e31\:0e27\:0e41\:0e1b\:0e23\:0e0a\:0e31\:0e48\:0e27\:0e04\:0e23\
\:0e32\:0e27 \:0e2a\:0e2d\:0e07\:0e15\:0e31\:0e27\:0e04\:0e37\:0e2d radius \
\:0e41\:0e25\:0e30 area\n\n\:0e2a\:0e48\:0e27\:0e19 radius = diameter/2; \
\:0e04\:0e37\:0e2d\:0e01\:0e32\:0e23\:0e01\:0e33\:0e2b\:0e19\:0e14\:0e04\:0e48\
\:0e32\:0e02\:0e2d\:0e07 radius  \:0e40\:0e04\:0e23\:0e37\:0e48\:0e2d\:0e07\
\:0e2b\:0e21\:0e32\:0e22 \";\" \:0e08\:0e33\:0e40\:0e1b\:0e47\:0e19\:0e08\
\:0e30\:0e15\:0e49\:0e2d\:0e07\:0e21\:0e35\:0e2b\:0e25\:0e31\:0e07\:0e17\:0e38\
\:0e01\:0e04\:0e33\:0e2a\:0e31\:0e48\:0e07\:0e20\:0e32\:0e22\:0e43\:0e19 \
Module \:0e22\:0e01\:0e40\:0e27\:0e49\:0e19\:0e04\:0e33\:0e2a\:0e31\:0e48\
\:0e07\:0e2a\:0e38\:0e14\:0e17\:0e49\:0e32\:0e22 \:0e0b\:0e36\:0e48\:0e07\
\:0e08\:0e30\:0e21\:0e35\:0e2b\:0e23\:0e37\:0e2d\:0e44\:0e21\:0e48\:0e01\:0e47\
\:0e44\:0e14\:0e49 \:0e42\:0e14\:0e22\:0e1b\:0e01\:0e15\:0e34\:0e04\:0e33\
\:0e2a\:0e31\:0e48\:0e07\:0e2a\:0e38\:0e14\:0e17\:0e49\:0e32\:0e22\:0e08\:0e30\
\:0e44\:0e21\:0e48\:0e21\:0e35 \";\" \:0e15\:0e48\:0e2d\:0e17\:0e49\:0e32\
\:0e22 \:0e0b\:0e36\:0e48\:0e07\:0e41\:0e1b\:0e25\:0e27\:0e48\:0e32\:0e1c\
\:0e25\:0e25\:0e31\:0e1e\:0e17\:0e4c\:0e02\:0e2d\:0e07\:0e04\:0e33\:0e2a\:0e31\
\:0e48\:0e07\:0e2a\:0e38\:0e14\:0e17\:0e49\:0e32\:0e22\:0e04\:0e37\:0e2d\:0e04\
\:0e48\:0e32\:0e17\:0e35\:0e48\:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19\
\:0e08\:0e30\:0e2a\:0e48\:0e07\:0e01\:0e25\:0e31\:0e1a\:0e44\:0e1b\:0e43\:0e2b\
\:0e49\:0e1c\:0e39\:0e49\:0e40\:0e23\:0e35\:0e22\:0e01\:0e43\:0e0a\:0e49\:0e1f\
\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19\:0e19\:0e31\:0e49\:0e19\:0e46\n\
\:0e16\:0e49\:0e32\:0e04\:0e33\:0e2a\:0e31\:0e48\:0e07\:0e2a\:0e38\:0e14\:0e17\
\:0e49\:0e32\:0e22\:0e21\:0e35 \";\" \:0e15\:0e48\:0e2d\:0e17\:0e49\:0e32\
\:0e22 \:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19\:0e01\:0e47\:0e08\
\:0e30\:0e44\:0e21\:0e48\:0e2a\:0e48\:0e07\:0e04\:0e48\:0e32\:0e43\:0e14\:0e46\
\:0e01\:0e25\:0e31\:0e1a\n\n\:0e2a\:0e48\:0e27\:0e19 area = Pi radius^2; \
\:0e04\:0e37\:0e2d\:0e01\:0e32\:0e23\:0e01\:0e33\:0e2b\:0e19\:0e14\:0e04\:0e48\
\:0e32\:0e02\:0e2d\:0e07\:0e1e\:0e37\:0e49\:0e19\:0e17\:0e35\:0e48\:0e02\:0e2d\
\:0e07\:0e27\:0e07\:0e01\:0e25\:0e21  A = \[Pi]",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["r", "2"], TraditionalForm]]],
 "  \:0e40\:0e19\:0e37\:0e48\:0e2d\:0e07\:0e08\:0e32\:0e01\:0e04\:0e33\:0e2a\
\:0e31\:0e48\:0e07\:0e19\:0e35\:0e49\:0e44\:0e21\:0e48\:0e43\:0e0a\:0e48\:0e04\
\:0e33\:0e2a\:0e31\:0e48\:0e07\:0e2a\:0e38\:0e14\:0e17\:0e49\:0e32\:0e22 \
\:0e08\:0e36\:0e07\:0e15\:0e49\:0e2d\:0e07\:0e21\:0e35 \";\"\n\narea \:0e43\
\:0e19\:0e1a\:0e23\:0e23\:0e17\:0e31\:0e14\:0e2a\:0e38\:0e14\:0e17\:0e49\:0e32\
\:0e22\:0e40\:0e1b\:0e47\:0e19\:0e04\:0e33\:0e2a\:0e31\:0e48\:0e07\:0e43\:0e2b\
\:0e49 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \:0e04\:0e33\:0e19\:0e27\:0e13\:0e04\:0e48\:0e32\:0e02\:0e2d\:0e07\:0e15\
\:0e31\:0e27\:0e41\:0e1b\:0e23 area \
\:0e0b\:0e36\:0e48\:0e07\:0e04\:0e37\:0e2d\:0e04\:0e48\:0e32\:0e17\:0e35\:0e48\
\:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19\:0e08\:0e30\:0e2a\:0e48\:0e07\
\:0e01\:0e25\:0e31\:0e1a\:0e44\:0e1b\:0e43\:0e2b\:0e49\:0e1c\:0e39\:0e49\:0e40\
\:0e23\:0e35\:0e22\:0e01\:0e43\:0e0a\:0e49\:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\
\:0e31\:0e19 myCircleArea\n\n\:0e15\:0e48\:0e2d\:0e44\:0e1b\:0e40\:0e23\:0e32\
\:0e17\:0e14\:0e25\:0e2d\:0e07\:0e43\:0e0a\:0e49 myCircleArea \:0e01\:0e31\
\:0e1a\:0e27\:0e07\:0e01\:0e25\:0e21\:0e17\:0e35\:0e48\:0e21\:0e35\:0e40\:0e2a\
\:0e49\:0e19\:0e1c\:0e48\:0e32\:0e28\:0e39\:0e19\:0e22\:0e4c\:0e01\:0e25\:0e32\
\:0e07 \:0e40\:0e17\:0e48\:0e32\:0e01\:0e31\:0e1a 2 \:0e41\:0e25\:0e30 20 \
\:0e2b\:0e19\:0e48\:0e27\:0e22"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myCircleArea", "[", "2", "]"}]], "Input"],

Cell[BoxData["\[Pi]"], "Output",
 CellChangeTimes->{3.583662847691135*^9, 3.583662996944441*^9, 
  3.5836635894926167`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myCircleArea", "[", "20", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"100", " ", "\[Pi]"}]], "Output",
 CellChangeTimes->{3.5836628477280407`*^9, 3.583662996981204*^9, 
  3.583663589528558*^9}]
}, Open  ]],

Cell[TextData[{
 "\:0e15\:0e31\:0e27\:0e2d\:0e22\:0e48\:0e32\:0e07\:0e17\:0e35\:0e48\:0e0b\
\:0e31\:0e1a\:0e0b\:0e49\:0e2d\:0e19\:0e02\:0e36\:0e49\:0e19: \:0e1f\:0e31\
\:0e07\:0e04\:0e4c\:0e0a\:0e31\:0e19\:0e17\:0e35\:0e48\:0e2b\:0e32\:0e04\:0e48\
\:0e32\:0e04\:0e25\:0e32\:0e14\:0e40\:0e04\:0e25\:0e37\:0e48\:0e2d\:0e19\:0e08\
\:0e32\:0e01\:0e01\:0e32\:0e23\:0e17\:0e14\:0e25\:0e2d\:0e07 comError[ ]\n\
\:0e16\:0e49\:0e32",
 StyleBox[" f = f(x, y, z, ...) ",
  FontSlant->"Italic"],
 "\:0e41\:0e25\:0e30 ",
 StyleBox["x, y, z, ... ",
  FontSlant->"Italic"],
 "\:0e40\:0e1b\:0e47\:0e19\:0e2d\:0e34\:0e2a\:0e23\:0e30\:0e15\:0e48\:0e2d\
\:0e01\:0e31\:0e19 (covariance(",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]]],
 ",",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "j"], TraditionalForm]]],
 ") = 0 \:0e16\:0e49\:0e32 ",
 StyleBox["i \[NotEqual] j",
  FontSlant->"Italic"],
 " )\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      StyleBox[
       RowBox[{"\[CapitalDelta]", 
        StyleBox["f",
         FontSlant->"Italic"]}]], ")"}], "2"], " ", "=", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"\[CapitalDelta]x", 
       RowBox[{
        SubscriptBox["\[PartialD]", "x"], " ", "f"}]}], ")"}], "2"]}], 
   TraditionalForm]]],
 "+",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"\[CapitalDelta]y", 
       RowBox[{
        SubscriptBox["\[PartialD]", "y"], " ", "f"}]}], ")"}], "2"]}], 
   TraditionalForm]]],
 "+",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"\[CapitalDelta]z", 
       RowBox[{
        SubscriptBox["\[PartialD]", "z"], " ", "f"}]}], ")"}], "2"]}], 
   TraditionalForm]]],
 "+...\n\n\:0e40\:0e23\:0e32\:0e08\:0e30\:0e04\:0e33\:0e19\:0e27\:0e13 \
\[CapitalDelta]",
 StyleBox["f",
  FontSlant->"Italic"],
 " \:0e14\:0e49\:0e27\:0e22 comError[ ]\n\ncomError[f,vars,dvars] \
\:0e43\:0e0a\:0e49 arguments \:0e40\:0e2b\:0e25\:0e48\:0e32\:0e19\:0e35\:0e49\
\:0e04\:0e37\:0e2d\nf \:0e04\:0e37\:0e2d\:0e1f\:0e31\:0e07\:0e04\:0e4c\:0e0a\
\:0e31\:0e19\:0e17\:0e35\:0e48\:0e40\:0e23\:0e32\:0e2a\:0e19\:0e43\:0e08\n\
vars \:0e04\:0e37\:0e2d\:0e25\:0e34\:0e2a\:0e15\:0e4c\:0e02\:0e2d\:0e07\:0e15\
\:0e31\:0e27\:0e41\:0e1b\:0e23\:0e17\:0e35\:0e48 f \:0e15\:0e49\:0e2d\:0e07\
\:0e01\:0e32\:0e23\ndvars \:0e04\:0e37\:0e2d\:0e25\:0e34\:0e2a\:0e15\:0e4c\
\:0e02\:0e2d\:0e07 standard deviations \:0e02\:0e2d\:0e07\:0e15\:0e31\:0e27\
\:0e41\:0e1b\:0e23\:0e17\:0e35\:0e48 f \:0e15\:0e49\:0e2d\:0e07\:0e01\:0e32\
\:0e23\n\n\:0e43\:0e19\:0e01\:0e32\:0e23\:0e04\:0e33\:0e19\:0e27\:0e13\:0e35\
\:0e48\:0e2b\:0e32\:0e04\:0e48\:0e32\:0e04\:0e25\:0e32\:0e14\:0e40\:0e04\:0e25\
\:0e37\:0e48\:0e2d\:0e19\:0e08\:0e32\:0e01\:0e01\:0e32\:0e23\:0e17\:0e14\:0e25\
\:0e2d\:0e07 \:0e40\:0e23\:0e32\:0e08\:0e30\:0e43\:0e0a\:0e49\:0e15\:0e31\
\:0e27\:0e41\:0e1b\:0e23\:0e0a\:0e31\:0e48\:0e27\:0e04\:0e23\:0e32\:0e27\:0e17\
\:0e35\:0e48\:0e08\:0e30\:0e40\:0e1b\:0e47\:0e19\:0e08\:0e33\:0e19\:0e27\:0e19\
\:0e15\:0e31\:0e27\:0e41\:0e1b\:0e23\:0e43\:0e19 vars (\:0e40\:0e23\:0e35\
\:0e22\:0e01\:0e27\:0e48\:0e32 numvars) \:0e41\:0e25\:0e30 \:0e25\:0e34\:0e2a\
\:0e15\:0e4c\:0e02\:0e2d\:0e07 partial derivatives \:0e02\:0e2d\:0e07 f \
\:0e40\:0e17\:0e35\:0e22\:0e1a\:0e01\:0e31\:0e1a vars (\:0e40\:0e23\:0e35\
\:0e22\:0e01\:0e27\:0e48\:0e32 df)\n\n\:0e40\:0e23\:0e32\:0e08\:0e30\:0e40\
\:0e02\:0e35\:0e22\:0e19\:0e04\:0e33\:0e2d\:0e18\:0e34\:0e1a\:0e32\:0e22\:0e44\
\:0e27\:0e49\:0e43\:0e19 (* ..... *)  \n\:0e08\:0e30\:0e21\:0e35\:0e04\:0e33\
\:0e2a\:0e31\:0e48\:0e07 Length, Print, Apply, Table, D \:0e0b\:0e36\:0e48\
\:0e07\:0e04\:0e38\:0e13\:0e2d\:0e32\:0e08\:0e08\:0e30\:0e44\:0e21\:0e48\:0e40\
\:0e2b\:0e47\:0e19\:0e21\:0e32\:0e01\:0e48\:0e2d\:0e19 \:0e02\:0e2d\:0e43\
\:0e2b\:0e49\:0e02\:0e49\:0e32\:0e21\:0e44\:0e1b (\:0e2b\:0e23\:0e37\:0e2d \
\:0e01\:0e14 Help/Master Index \:0e2b\:0e23\:0e37\:0e2d ? \:0e14\:0e39\:0e40\
\:0e1e\:0e34\:0e48\:0e21\:0e40\:0e15\:0e34\:0e21\:0e40\:0e2d\:0e07)  \:0e1c\
\:0e21\:0e08\:0e30\:0e21\:0e32\:0e2d\:0e18\:0e34\:0e1a\:0e32\:0e22\:0e04\:0e33\
\:0e2a\:0e31\:0e48\:0e07\:0e40\:0e2b\:0e25\:0e48\:0e32\:0e19\:0e35\:0e49\:0e43\
\:0e19\:0e04\:0e23\:0e31\:0e49\:0e07\:0e15\:0e48\:0e2d\:0e46\:0e44\:0e1b"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"comError", "[", 
   RowBox[{"f_", ",", "vars_", ",", "dvars_"}], "]"}], ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"numvars", ",", "df"}], "}"}], ",", 
    RowBox[{"(*", " ", 
     RowBox[{
     "\:0e1b\:0e23\:0e30\:0e01\:0e32\:0e28\:0e27\:0e48\:0e32", " ", 
      "\:0e04\:0e31\:0e27\:0e41\:0e1b\:0e23\:0e0a\:0e31\:0e48\:0e27\:0e04\
\:0e23\:0e32\:0e27\:0e0a\:0e37\:0e48\:0e2d", " ", "numvars", " ", 
      "\:0e41\:0e25\:0e30", " ", "df"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"numvars", " ", "=", " ", 
      RowBox[{"Length", "[", "vars", "]"}]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "numvar", " ", "=", " ", 
       "\:0e08\:0e33\:0e19\:0e27\:0e19\:0e15\:0e31\:0e27\:0e41\:0e1b\:0e23"}],
       " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<functions: \>\"", " ", ",", 
       RowBox[{"Apply", "[", 
        RowBox[{"f", ",", "vars"}], "]"}]}], "]"}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "\:0e41\:0e2a\:0e14\:0e07\:0e27\:0e48\:0e32\:0e1f\:0e31\:0e07\:0e04\
\:0e4c\:0e0a\:0e31\:0e19", " ", "f", " ", 
       "\:0e2b\:0e19\:0e49\:0e32\:0e15\:0e32\:0e40\:0e1b\:0e47\:0e19\:0e2d\
\:0e22\:0e48\:0e32\:0e07\:0e44\:0e23"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"df", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"Apply", "[", 
           RowBox[{"f", ",", "vars"}], "]"}], ",", 
          RowBox[{"vars", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "numvars"}], "}"}]}], "]"}]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{"df", " ", "=", " ", 
       RowBox[{
       "\:0e25\:0e34\:0e2a\:0e15\:0e4c\:0e02\:0e2d\:0e07", " ", "partial", 
        " ", "derivative", " ", "\:0e02\:0e2d\:0e07", " ", "f", " ", 
        "\:0e40\:0e17\:0e35\:0e22\:0e1a\:0e01\:0e31\:0e1a", " ", 
        "\:0e04\:0e31\:0e27\:0e41\:0e1b\:0e23\:0e17\:0e31\:0e49\:0e07\:0e2b\
\:0e25\:0e32\:0e22"}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Result and Uncertainty:\\t{\>\"", ",", " ", 
       RowBox[{"Apply", "[", 
        RowBox[{"f", ",", "vars"}], "]"}], ",", "\"\<} \[PlusMinus] {\>\"", 
       ",", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"Dot", "[", 
         RowBox[{
          RowBox[{"df", "^", "2"}], ",", 
          RowBox[{"dvars", "^", "2"}]}], "]"}], "]"}], ",", "\"\<}\>\""}], 
      "]"}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "\:0e41\:0e2a\:0e14\:0e07", " ", "\:0e1c\:0e25", " ", 
       "\:0e02\:0e2d\:0e07", " ", "f", " ", "\:0e41\:0e25\:0e30", " ", 
       "\[CapitalDelta]f"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Apply", "[", 
        RowBox[{"f", ",", "vars"}], "]"}], ",", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"Dot", "[", 
         RowBox[{
          RowBox[{"df", "^", "2"}], ",", 
          RowBox[{"dvars", "^", "2"}]}], "]"}], "]"}]}], "}"}]}]}], "]"}], 
  RowBox[{"(*", 
   RowBox[{
   "\:0e1c\:0e25\:0e02\:0e2d\:0e07", " ", "comError", " ", 
    "\:0e04\:0e37\:0e2d\:0e04\:0e39\:0e48\:0e25\:0e33\:0e14\:0e31\:0e1a", " ", 
    RowBox[{"{", 
     RowBox[{"f", ",", "\[CapitalDelta]f"}], "}"}]}], " ", "*)"}]}]], "Input"],

Cell["\<\
\:0e17\:0e14\:0e25\:0e2d\:0e07\:0e01\:0e31\:0e1a\:0e1f\:0e31\:0e07\:0e04\:0e4c\
\:0e0a\:0e31\:0e19 f3(x,y,z) = x+y+z\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f3", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], " ", ":=", " ", 
  RowBox[{"x", "+", "y", "+", "z"}]}], "\[IndentingNewLine]", 
 RowBox[{"comError", "[", 
  RowBox[{"f3", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "\[CapitalDelta]x", ",", " ", "\[CapitalDelta]y", ",", 
     "\[CapitalDelta]z"}], "}"}]}], "]"}]}], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"functions: \"\>", "\[InvisibleSpace]", 
   RowBox[{"x", "+", "y", "+", "z"}]}],
  SequenceForm[
  "functions: ", $CellContext`x + $CellContext`y + $CellContext`z],
  Editable->False]], "Print",
 CellChangeTimes->{3.583662847831841*^9, 3.5836629970480633`*^9, 
  3.583663589752887*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Result and Uncertainty:\\t{\"\>", "\[InvisibleSpace]", 
   RowBox[{"x", "+", "y", "+", "z"}], 
   "\[InvisibleSpace]", "\<\"} \[PlusMinus] {\"\>", "\[InvisibleSpace]", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["\[CapitalDelta]x", "2"], "+", 
     SuperscriptBox["\[CapitalDelta]y", "2"], "+", 
     SuperscriptBox["\[CapitalDelta]z", "2"]}]], 
   "\[InvisibleSpace]", "\<\"}\"\>"}],
  SequenceForm[
  "Result and Uncertainty:\t{", $CellContext`x + $CellContext`y + \
$CellContext`z, 
   "} \[PlusMinus] {", ($CellContext`\[CapitalDelta]x^2 + $CellContext`\
\[CapitalDelta]y^2 + $CellContext`\[CapitalDelta]z^2)^Rational[1, 2], "}"],
  Editable->False]], "Print",
 CellChangeTimes->{3.583662847831841*^9, 3.5836629970480633`*^9, 
  3.583663589755185*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "+", "y", "+", "z"}], ",", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["\[CapitalDelta]x", "2"], "+", 
     SuperscriptBox["\[CapitalDelta]y", "2"], "+", 
     SuperscriptBox["\[CapitalDelta]z", "2"]}]]}], "}"}]], "Output",
 CellChangeTimes->{3.583662847833992*^9, 3.5836629970501213`*^9, 
  3.58366358975736*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"comError", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"{", "\[CapitalDelta]x", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"functions: \"\>", "\[InvisibleSpace]", 
   SuperscriptBox["x", "2"]}],
  SequenceForm["functions: ", $CellContext`x^2],
  Editable->False]], "Print",
 CellChangeTimes->{3.583662847878763*^9, 3.5836629970822144`*^9, 
  3.583663589794722*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Result and Uncertainty:\\t{\"\>", "\[InvisibleSpace]", 
   SuperscriptBox["x", "2"], "\[InvisibleSpace]", "\<\"} \[PlusMinus] {\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      SuperscriptBox["\[CapitalDelta]x", "2"]}]]}], 
   "\[InvisibleSpace]", "\<\"}\"\>"}],
  SequenceForm[
  "Result and Uncertainty:\t{", $CellContext`x^2, "} \[PlusMinus] {", 
   2 ($CellContext`x^2 $CellContext`\[CapitalDelta]x^2)^Rational[1, 2], "}"],
  Editable->False]], "Print",
 CellChangeTimes->{3.583662847878763*^9, 3.5836629970822144`*^9, 
  3.58366358979626*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      SuperscriptBox["\[CapitalDelta]x", "2"]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{3.583662847880665*^9, 3.583662997084197*^9, 
  3.583663589797433*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"comError", "[", 
  RowBox[{"f2", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "\[CapitalDelta]x", ",", "\[CapitalDelta]y", ",", "\[CapitalDelta]d"}], 
    "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"functions: \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], 
    RowBox[{"2", " ", 
     SuperscriptBox["d", "2"]}]]}],
  SequenceForm[
  "functions: ", 
   Rational[1, 2] $CellContext`d^(-2) ($CellContext`x^2 + $CellContext`y^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.583662847927672*^9, 3.58366299711766*^9, 
  3.583663589846426*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Result and Uncertainty:\\t{\"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], 
    RowBox[{"2", " ", 
     SuperscriptBox["d", "2"]}]], 
   "\[InvisibleSpace]", "\<\"} \[PlusMinus] {\"\>", "\[InvisibleSpace]", 
   SqrtBox[
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["\[CapitalDelta]d", "2"]}], 
      SuperscriptBox["d", "6"]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["x", "2"], " ", 
       SuperscriptBox["\[CapitalDelta]x", "2"]}], 
      SuperscriptBox["d", "4"]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["y", "2"], " ", 
       SuperscriptBox["\[CapitalDelta]y", "2"]}], 
      SuperscriptBox["d", "4"]]}]], "\[InvisibleSpace]", "\<\"}\"\>"}],
  SequenceForm[
  "Result and Uncertainty:\t{", 
   Rational[1, 2] $CellContext`d^(-2) ($CellContext`x^2 + $CellContext`y^2), 
   "} \[PlusMinus] {", ($CellContext`d^(-6) ($CellContext`x^2 + \
$CellContext`y^2)^2 $CellContext`\[CapitalDelta]d^2 + $CellContext`d^(-4) \
$CellContext`x^2 $CellContext`\[CapitalDelta]x^2 + $CellContext`d^(-4) \
$CellContext`y^2 $CellContext`\[CapitalDelta]y^2)^Rational[1, 2], "}"],
  Editable->False]], "Print",
 CellChangeTimes->{3.583662847927672*^9, 3.58366299711766*^9, 
  3.5836635898477087`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], 
    RowBox[{"2", " ", 
     SuperscriptBox["d", "2"]}]], ",", 
   SqrtBox[
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["\[CapitalDelta]d", "2"]}], 
      SuperscriptBox["d", "6"]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["x", "2"], " ", 
       SuperscriptBox["\[CapitalDelta]x", "2"]}], 
      SuperscriptBox["d", "4"]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["y", "2"], " ", 
       SuperscriptBox["\[CapitalDelta]y", "2"]}], 
      SuperscriptBox["d", "4"]]}]]}], "}"}]], "Output",
 CellChangeTimes->{3.583662847930217*^9, 3.58366299711981*^9, 
  3.583663589849333*^9}]
}, Open  ]],

Cell["\<\
\:0e41\:0e17\:0e19\:0e04\:0e48\:0e32 x = 1, y = 0, d= 0.1, \
\[CapitalDelta]x=0.01,\[CapitalDelta]y=0.01,\[CapitalDelta]d=0.01\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"comError", "[", 
   RowBox[{"f2", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "d"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "\[CapitalDelta]x", ",", "\[CapitalDelta]y", ",", "\[CapitalDelta]d"}], 
     "}"}]}], "]"}], " ", "/.", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", " ", "1"}], ",", " ", 
    RowBox[{"y", "\[Rule]", "0"}], ",", " ", 
    RowBox[{"d", "\[Rule]", "0.1"}], ",", 
    RowBox[{"\[CapitalDelta]x", "\[Rule]", "0.01"}], ",", " ", 
    RowBox[{"\[CapitalDelta]y", " ", "\[Rule]", " ", "0.01"}], ",", " ", 
    RowBox[{"\[CapitalDelta]d", " ", "\[Rule]", " ", "0.01"}]}], 
   "}"}]}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"functions: \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], 
    RowBox[{"2", " ", 
     SuperscriptBox["d", "2"]}]]}],
  SequenceForm[
  "functions: ", 
   Rational[1, 2] $CellContext`d^(-2) ($CellContext`x^2 + $CellContext`y^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.583662847977891*^9, 3.583662997162723*^9, 
  3.583663589896943*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Result and Uncertainty:\\t{\"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], 
    RowBox[{"2", " ", 
     SuperscriptBox["d", "2"]}]], 
   "\[InvisibleSpace]", "\<\"} \[PlusMinus] {\"\>", "\[InvisibleSpace]", 
   SqrtBox[
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["\[CapitalDelta]d", "2"]}], 
      SuperscriptBox["d", "6"]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["x", "2"], " ", 
       SuperscriptBox["\[CapitalDelta]x", "2"]}], 
      SuperscriptBox["d", "4"]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["y", "2"], " ", 
       SuperscriptBox["\[CapitalDelta]y", "2"]}], 
      SuperscriptBox["d", "4"]]}]], "\[InvisibleSpace]", "\<\"}\"\>"}],
  SequenceForm[
  "Result and Uncertainty:\t{", 
   Rational[1, 2] $CellContext`d^(-2) ($CellContext`x^2 + $CellContext`y^2), 
   "} \[PlusMinus] {", ($CellContext`d^(-6) ($CellContext`x^2 + \
$CellContext`y^2)^2 $CellContext`\[CapitalDelta]d^2 + $CellContext`d^(-4) \
$CellContext`x^2 $CellContext`\[CapitalDelta]x^2 + $CellContext`d^(-4) \
$CellContext`y^2 $CellContext`\[CapitalDelta]y^2)^Rational[1, 2], "}"],
  Editable->False]], "Print",
 CellChangeTimes->{3.583662847977891*^9, 3.583662997162723*^9, 
  3.583663589898188*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"49.99999999999999`", ",", "10.049875621120888`"}], "}"}]], "Output",
 CellChangeTimes->{3.583662847979961*^9, 3.5836629971647167`*^9, 
  3.583663589899283*^9}]
}, Open  ]],

Cell["\<\
\:0e16\:0e49\:0e32\:0e40\:0e23\:0e32\:0e44\:0e21\:0e48\:0e43\:0e0a\:0e49 \
Module[ ] \:0e15\:0e31\:0e27\:0e41\:0e1b\:0e23\:0e2d\:0e30\:0e44\:0e23\:0e01\
\:0e47\:0e15\:0e32\:0e21\:0e17\:0e35\:0e48\:0e40\:0e23\:0e32\:0e01\:0e33\:0e2b\
\:0e19\:0e14\:0e23\:0e30\:0e2b\:0e27\:0e48\:0e32\:0e07\:0e01\:0e32\:0e23\:0e04\
\:0e33\:0e19\:0e27\:0e13\:0e02\:0e2d\:0e07\:0e40\:0e23\:0e32 \:0e01\:0e47\
\:0e08\:0e30\:0e04\:0e07\:0e2d\:0e22\:0e39\:0e48\:0e43\:0e2b\:0e49\:0e40\:0e2b\
\:0e47\:0e19\:0e2b\:0e25\:0e31\:0e07\:0e08\:0e32\:0e01\:0e01\:0e32\:0e23\:0e04\
\:0e33\:0e19\:0e27\:0e13\:0e40\:0e2a\:0e23\:0e47\:0e08\:0e2a\:0e34\:0e49\:0e19\
\:0e44\:0e1b\:0e41\:0e25\:0e49\:0e27 \:0e41\:0e25\:0e30\:0e21\:0e31\:0e01\
\:0e08\:0e30\:0e44\:0e1b\:0e17\:0e31\:0e1a\:0e0b\:0e49\:0e2d\:0e19\:0e15\:0e31\
\:0e27\:0e41\:0e1b\:0e23\:0e17\:0e35\:0e48\:0e21\:0e35\:0e0a\:0e37\:0e48\:0e2d\
\:0e40\:0e2b\:0e21\:0e35\:0e2d\:0e19\:0e01\:0e31\:0e19 \:0e17\:0e33\:0e43\
\:0e2b\:0e49\:0e40\:0e23\:0e32\:0e21\:0e35\:0e42\:0e2d\:0e01\:0e32\:0e2a\:0e17\
\:0e33\:0e1c\:0e34\:0e14\:0e1e\:0e25\:0e32\:0e14\:0e21\:0e32\:0e01\:0e02\:0e36\
\:0e49\:0e19  \:0e16\:0e49\:0e32\:0e21\:0e35\:0e40\:0e2b\:0e15\:0e38\:0e01\
\:0e32\:0e23\:0e13\:0e4c\:0e2d\:0e22\:0e48\:0e32\:0e07\:0e19\:0e31\:0e49\:0e19\
\:0e40\:0e01\:0e34\:0e14\:0e02\:0e36\:0e49\:0e19 \:0e40\:0e23\:0e32\:0e08\
\:0e30\:0e15\:0e49\:0e2d\:0e07\:0e43\:0e0a\:0e49 Clear[ ] \:0e2b\:0e23\:0e37\
\:0e2d Remove[ ] \:0e15\:0e31\:0e27\:0e41\:0e1b\:0e23\:0e40\:0e2b\:0e25\:0e48\
\:0e32\:0e19\:0e31\:0e49\:0e19 

\:0e43\:0e19\:0e15\:0e31\:0e27\:0e2d\:0e22\:0e48\:0e32\:0e07\:0e19\:0e35\:0e49\
\:0e15\:0e31\:0e27\:0e41\:0e1b\:0e23\:0e0a\:0e31\:0e48\:0e27\:0e04\:0e23\:0e32\
\:0e27\:0e21\:0e35\:0e40\:0e1e\:0e35\:0e22\:0e07\:0e2a\:0e2d\:0e07\:0e15\:0e31\
\:0e27\:0e08\:0e36\:0e07\:0e44\:0e21\:0e48\:0e40\:0e2b\:0e47\:0e19\:0e1c\:0e25\
\:0e40\:0e2a\:0e35\:0e22\:0e19\:0e31\:0e01 \:0e1c\:0e25\:0e40\:0e2a\:0e35\
\:0e22\:0e08\:0e30\:0e40\:0e2b\:0e47\:0e19\:0e0a\:0e31\:0e14\:0e43\:0e19\:0e01\
\:0e32\:0e23\:0e40\:0e02\:0e35\:0e22\:0e19\:0e42\:0e1b\:0e23\:0e41\:0e01\:0e23\
\:0e21\:0e17\:0e35\:0e48\:0e0b\:0e31\:0e1a\:0e0b\:0e49\:0e2d\:0e19\:0e22\:0e34\
\:0e48\:0e07\:0e02\:0e36\:0e49\:0e19 \:0e40\:0e27\:0e25\:0e32\:0e17\:0e35\
\:0e48\:0e21\:0e35\:0e15\:0e31\:0e27\:0e41\:0e1b\:0e23\:0e0a\:0e31\:0e48\:0e27\
\:0e04\:0e23\:0e32\:0e27\:0e2b\:0e25\:0e32\:0e22\:0e15\:0e31\:0e27
\
\>", "Text"],

Cell[TextData[{
 "\n\:0e27\:0e31\:0e19\:0e19\:0e35\:0e49\:0e02\:0e2d\:0e08\:0e1a\:0e41\:0e04\
\:0e48\:0e19\:0e35\:0e49\:0e01\:0e48\:0e2d\:0e19  \:0e2b\:0e27\:0e31\:0e07\
\:0e27\:0e48\:0e32\:0e04\:0e38\:0e13\:0e08\:0e30\:0e1e\:0e1a\:0e27\:0e48\:0e32\
 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \:0e19\:0e31\:0e49\:0e19\:0e21\:0e35\:0e1b\:0e23\:0e30\:0e42\:0e22\:0e0a\
\:0e19\:0e4c\:0e43\:0e19\:0e01\:0e32\:0e23\:0e28\:0e36\:0e01\:0e29\:0e32\:0e17\
\:0e32\:0e07\:0e14\:0e49\:0e32\:0e19\:0e27\:0e34\:0e17\:0e22\:0e32\:0e28\:0e32\
\:0e2a\:0e15\:0e23\:0e4c\:0e19\:0e30\:0e04\:0e23\:0e31\:0e1a \:0e15\:0e2d\
\:0e19\:0e1c\:0e21\:0e40\:0e1b\:0e47\:0e19\:0e19\:0e31\:0e01\:0e40\:0e23\:0e35\
\:0e22\:0e19\:0e2d\:0e22\:0e39\:0e48 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 1.0 \:0e1e\:0e36\:0e48\:0e07\:0e2d\:0e2d\:0e01\:0e21\:0e32 \:0e41\:0e25\
\:0e30\:0e1c\:0e21\:0e01\:0e47\:0e43\:0e0a\:0e49\:0e0a\:0e48\:0e27\:0e22\:0e43\
\:0e19\:0e01\:0e32\:0e23\:0e40\:0e23\:0e35\:0e22\:0e19\:0e41\:0e25\:0e30\:0e17\
\:0e33\:0e04\:0e27\:0e32\:0e21\:0e40\:0e02\:0e49\:0e32\:0e43\:0e08\:0e43\:0e19\
\:0e40\:0e23\:0e37\:0e48\:0e2d\:0e07\:0e15\:0e48\:0e32\:0e07\:0e46\:0e44\:0e14\
\:0e49\:0e40\:0e1b\:0e47\:0e19\:0e2d\:0e22\:0e48\:0e32\:0e07\:0e14\:0e35 \n\n\
\:0e43\:0e19\:0e15\:0e2d\:0e19\:0e14\:0e48\:0e2d\:0e46\:0e44\:0e1b \:0e1c\
\:0e21\:0e08\:0e30\:0e40\:0e19\:0e49\:0e19\:0e23\:0e32\:0e22\:0e25\:0e30\:0e40\
\:0e2d\:0e35\:0e22\:0e14\:0e43\:0e19\:0e40\:0e23\:0e37\:0e48\:0e2d\:0e07\:0e15\
\:0e48\:0e32\:0e07\:0e46\:0e21\:0e32\:0e01\:0e02\:0e36\:0e49\:0e19 \:0e16\
\:0e49\:0e32\:0e43\:0e04\:0e23\:0e21\:0e35\:0e2d\:0e30\:0e44\:0e23\:0e2a\:0e19\
\:0e43\:0e08\:0e40\:0e1b\:0e47\:0e19\:0e1e\:0e34\:0e40\:0e28\:0e29 \:0e01\
\:0e47\:0e0a\:0e48\:0e27\:0e22\:0e1a\:0e2d\:0e01\:0e44\:0e27\:0e49\:0e43\:0e19\
 http://mpec.sc.mahidol.ac.th/ \:0e2b\:0e23\:0e37\:0e2d\:0e40\:0e21\:0e25\
\:0e4c\:0e1c\:0e21 \:0e17\:0e35\:0e48 ",
 ButtonBox["psaipetc@alumni.caltech.edu",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["mailto:psaipetc@alumni.caltech.edu"], None}],
 " \:0e19\:0e30\:0e04\:0e23\:0e31\:0e1a"
}], "Text"]
}, Open  ]]
},
WindowSize->{1105, 869},
WindowMargins->{{31, Automatic}, {Automatic, 10}},
ShowSelection->True,
CellLabelAutoDelete->True,
Magnification->1,
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, \
2013)",
StyleDefinitions->"Classroom.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3583688778-1507343"->{
  Cell[21445, 773, 120, 2, 40, "Print",
   CellTags->"Info3583688778-1507343"],
  Cell[21568, 777, 767, 21, 24, "Print",
   CellTags->"Info3583688778-1507343"]},
 "Info3583688779-1507343"->{
  Cell[22421, 806, 122, 2, 40, "Print",
   CellTags->"Info3583688779-1507343"],
  Cell[22546, 810, 748, 21, 22, "Print",
   CellTags->"Info3583688779-1507343"]},
 "Info3583688780-1507343"->{
  Cell[23697, 848, 120, 2, 40, "Print",
   CellTags->"Info3583688780-1507343"]},
 "Info3583688781-1507343"->{
  Cell[31089, 1107, 727, 15, 58, "Print",
   CellTags->"Info3583688781-1507343"],
  Cell[31912, 1130, 806, 16, 58, "Print",
   CellTags->"Info3583688781-1507343"]},
 "Info3583688782-1507343"->{
  Cell[32807, 1154, 1122, 20, 74, "Print",
   CellTags->"Info3583688782-1507343"]},
 "Info3583688783-1507343"->{
  Cell[38073, 1339, 2770, 43, 108, "Print",
   CellTags->"Info3583688783-1507343"]},
 "Info3583688784-1507343"->{
  Cell[41962, 1431, 2880, 45, 124, "Print",
   CellTags->"Info3583688784-1507343"]},
 "Info3583688787-2646576"->{
  Cell[143194, 3327, 118, 2, 40, "Print",
   CellTags->"Info3583688787-2646576"],
  Cell[143315, 3331, 812, 23, 24, "Print",
   CellTags->"Info3583688787-2646576"]},
 "Info3583688788-2646576"->{
  Cell[144212, 3362, 119, 2, 40, "Print",
   CellTags->"Info3583688788-2646576"],
  Cell[144334, 3366, 1013, 29, 36, "Print",
   CellTags->"Info3583688788-2646576"]},
 "Info3583688789-2646576"->{
  Cell[145435, 3403, 122, 2, 40, "Print",
   CellTags->"Info3583688789-2646576"],
  Cell[145560, 3407, 1022, 28, 27, "Print",
   CellTags->"Info3583688789-2646576"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3583688778-1507343", 178972, 4184},
 {"Info3583688779-1507343", 179163, 4189},
 {"Info3583688780-1507343", 179354, 4194},
 {"Info3583688781-1507343", 179464, 4197},
 {"Info3583688782-1507343", 179658, 4202},
 {"Info3583688783-1507343", 179771, 4205},
 {"Info3583688784-1507343", 179885, 4208},
 {"Info3583688787-2646576", 179999, 4211},
 {"Info3583688788-2646576", 180194, 4216},
 {"Info3583688789-2646576", 180390, 4221}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 386, 7, 62, "Title"],
Cell[946, 29, 311, 8, 41, "Subtitle"],
Cell[1260, 39, 284, 8, 41, "Subtitle"],
Cell[1547, 49, 197, 2, 40, "Subtitle"],
Cell[CellGroupData[{
Cell[1769, 55, 256, 4, 47, "Subsection"],
Cell[2028, 61, 1031, 21, 27, "Text"],
Cell[3062, 84, 58, 0, 26, "Text"],
Cell[CellGroupData[{
Cell[3145, 88, 204, 6, 45, "Input"],
Cell[3352, 96, 141, 3, 64, "Output"]
}, Open  ]],
Cell[3508, 102, 76, 0, 25, "Text"],
Cell[CellGroupData[{
Cell[3609, 106, 99, 3, 45, "Input"],
Cell[3711, 111, 151, 4, 67, "Output"]
}, Open  ]],
Cell[3877, 118, 162, 3, 24, "Text"],
Cell[CellGroupData[{
Cell[4064, 125, 57, 1, 46, "Input"],
Cell[4124, 128, 147, 3, 46, "Output"]
}, Open  ]],
Cell[4286, 134, 326, 5, 26, "Text"],
Cell[CellGroupData[{
Cell[4637, 143, 237, 7, 45, "Input"],
Cell[4877, 152, 121, 2, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5035, 159, 129, 4, 45, "Input"],
Cell[5167, 165, 135, 2, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5339, 172, 85, 2, 46, "Input"],
Cell[5427, 176, 136, 2, 45, "Output"]
}, Open  ]],
Cell[5578, 181, 340, 6, 27, "Text"],
Cell[CellGroupData[{
Cell[5943, 191, 280, 9, 45, "Input"],
Cell[6226, 202, 121, 2, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6384, 209, 125, 4, 45, "Input"],
Cell[6512, 215, 137, 2, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6686, 222, 81, 2, 46, "Input"],
Cell[6770, 226, 138, 2, 45, "Output"]
}, Open  ]],
Cell[6923, 231, 410, 6, 26, "Text"],
Cell[CellGroupData[{
Cell[7358, 241, 272, 8, 45, "Input"],
Cell[7633, 251, 126, 2, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7796, 258, 156, 5, 45, "Input"],
Cell[7955, 265, 180, 3, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8172, 273, 110, 3, 46, "Input"],
Cell[8285, 278, 203, 4, 45, "Output"]
}, Open  ]],
Cell[8503, 285, 363, 6, 27, "Text"],
Cell[CellGroupData[{
Cell[8891, 295, 206, 6, 45, "Input"],
Cell[9100, 303, 123, 2, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9260, 310, 100, 3, 45, "Input"],
Cell[9363, 315, 136, 2, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9536, 322, 58, 1, 46, "Input"],
Cell[9597, 325, 133, 2, 45, "Output"]
}, Open  ]],
Cell[9745, 330, 417, 10, 192, "Text"],
Cell[CellGroupData[{
Cell[10187, 344, 49, 1, 45, "Input"],
Cell[10239, 347, 119, 2, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10395, 354, 49, 1, 45, "Input"],
Cell[10447, 357, 136, 3, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10620, 365, 73, 2, 45, "Input"],
Cell[10696, 369, 167, 4, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10900, 378, 159, 5, 45, "Input"],
Cell[11062, 385, 117, 2, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11216, 392, 50, 1, 45, "Input"],
Cell[11269, 395, 130, 2, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11436, 402, 79, 2, 45, "Input"],
Cell[11518, 406, 133, 2, 47, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11700, 414, 108, 2, 47, "Subsection"],
Cell[11811, 418, 252, 7, 27, "Text"],
Cell[CellGroupData[{
Cell[12088, 429, 49, 1, 45, "Input"],
Cell[12140, 432, 138, 3, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12315, 440, 49, 1, 45, "Input"],
Cell[12367, 443, 151, 3, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12555, 451, 138, 5, 45, "Input"],
Cell[12696, 458, 117, 2, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12850, 465, 96, 3, 45, "Input"],
Cell[12949, 470, 191, 5, 45, "Output"]
}, Open  ]],
Cell[13155, 478, 209, 4, 26, "Text"],
Cell[CellGroupData[{
Cell[13389, 486, 97, 3, 45, "Input"],
Cell[13489, 491, 117, 2, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13643, 498, 97, 3, 45, "Input"],
Cell[13743, 503, 119, 2, 45, "Output"]
}, Open  ]],
Cell[13877, 508, 65, 0, 24, "Text"],
Cell[CellGroupData[{
Cell[13967, 512, 98, 3, 45, "Input"],
Cell[14068, 517, 127, 3, 49, "Output"]
}, Open  ]],
Cell[14210, 523, 127, 1, 27, "Text"],
Cell[CellGroupData[{
Cell[14362, 528, 98, 3, 46, "Input"],
Cell[14463, 533, 151, 3, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14651, 541, 79, 2, 46, "Input"],
Cell[14733, 545, 159, 4, 61, "Output"]
}, Open  ]],
Cell[14907, 552, 115, 1, 26, "Text"],
Cell[CellGroupData[{
Cell[15047, 557, 104, 3, 46, "Input"],
Cell[15154, 562, 178, 4, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15369, 571, 142, 4, 46, "Input"],
Cell[15514, 577, 174, 4, 45, "Output"]
}, Open  ]],
Cell[15703, 584, 358, 6, 26, "Text"],
Cell[CellGroupData[{
Cell[16086, 594, 164, 5, 46, "Input"],
Cell[16253, 601, 406, 12, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16696, 618, 155, 4, 46, "Input"],
Cell[16854, 624, 333, 9, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17224, 638, 253, 8, 46, "Input"],
Cell[17480, 648, 616, 20, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18133, 673, 145, 4, 46, "Input"],
Cell[18281, 679, 616, 20, 65, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18946, 705, 58, 0, 43, "Subsection"],
Cell[19007, 707, 360, 6, 26, "Text"],
Cell[CellGroupData[{
Cell[19392, 717, 113, 3, 45, "Input"],
Cell[19508, 722, 139, 2, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19684, 729, 61, 1, 45, "Input"],
Cell[19748, 732, 120, 2, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19905, 739, 53, 1, 45, "Input"],
Cell[19961, 742, 139, 2, 47, "Output"]
}, Open  ]],
Cell[20115, 747, 1256, 19, 85, "Text"],
Cell[CellGroupData[{
Cell[21396, 770, 46, 1, 45, "Input"],
Cell[21445, 773, 120, 2, 40, "Print",
 CellTags->"Info3583688778-1507343"],
Cell[21568, 777, 767, 21, 24, "Print",
 CellTags->"Info3583688778-1507343"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22372, 803, 46, 1, 45, "Input"],
Cell[22421, 806, 122, 2, 40, "Print",
 CellTags->"Info3583688779-1507343"],
Cell[22546, 810, 748, 21, 22, "Print",
 CellTags->"Info3583688779-1507343"]
}, Open  ]],
Cell[23309, 834, 251, 4, 26, "Text"],
Cell[23563, 840, 60, 1, 45, "Input"],
Cell[CellGroupData[{
Cell[23648, 845, 46, 1, 45, "Input"],
Cell[23697, 848, 120, 2, 40, "Print",
 CellTags->"Info3583688780-1507343"]
}, Open  ]],
Cell[23832, 853, 389, 6, 27, "Text"],
Cell[24224, 861, 61, 1, 45, "Input"],
Cell[CellGroupData[{
Cell[24310, 866, 46, 1, 45, "Input"],
Cell[24359, 869, 507, 10, 24, "Message"]
}, Open  ]],
Cell[24881, 882, 177, 4, 26, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25095, 891, 149, 3, 47, "Subsection"],
Cell[25247, 896, 1045, 18, 115, "Text"],
Cell[CellGroupData[{
Cell[26317, 918, 57, 1, 45, "Input"],
Cell[26377, 921, 118, 2, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26532, 928, 57, 1, 45, "Input"],
Cell[26592, 931, 134, 3, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26763, 939, 114, 3, 46, "Input"],
Cell[26880, 944, 141, 3, 61, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27058, 952, 59, 1, 45, "Input"],
Cell[27120, 955, 143, 3, 61, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27300, 963, 56, 1, 46, "Input"],
Cell[27359, 966, 119, 2, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27515, 973, 56, 1, 46, "Input"],
Cell[27574, 976, 133, 2, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27744, 983, 57, 1, 46, "Input"],
Cell[27804, 986, 123, 2, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27964, 993, 75, 2, 45, "Input"],
Cell[28042, 997, 118, 2, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28197, 1004, 80, 2, 45, "Input"],
Cell[28280, 1008, 119, 2, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28436, 1015, 395, 14, 46, "Input"],
Cell[28834, 1031, 412, 14, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29283, 1050, 218, 6, 45, "Input"],
Cell[29504, 1058, 360, 11, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29901, 1074, 68, 1, 46, "Input"],
Cell[29972, 1077, 262, 8, 45, "Output"]
}, Open  ]],
Cell[30249, 1088, 764, 12, 27, "Text"],
Cell[CellGroupData[{
Cell[31038, 1104, 48, 1, 46, "Input"],
Cell[31089, 1107, 727, 15, 58, "Print",
 CellTags->"Info3583688781-1507343"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31853, 1127, 56, 1, 46, "Input"],
Cell[31912, 1130, 806, 16, 58, "Print",
 CellTags->"Info3583688781-1507343"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32755, 1151, 49, 1, 45, "Input"],
Cell[32807, 1154, 1122, 20, 74, "Print",
 CellTags->"Info3583688782-1507343"]
}, Open  ]],
Cell[33944, 1177, 422, 7, 27, "Text"],
Cell[CellGroupData[{
Cell[34391, 1188, 138, 4, 45, "Input"],
Cell[34532, 1194, 218, 6, 63, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34787, 1205, 167, 5, 45, "Input"],
Cell[34957, 1212, 300, 9, 64, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35294, 1226, 267, 9, 46, "Input"],
Cell[35564, 1237, 151, 3, 64, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35752, 1245, 217, 7, 45, "Input"],
Cell[35972, 1254, 162, 4, 63, "Output"]
}, Open  ]],
Cell[36149, 1261, 472, 9, 81, "Text"],
Cell[CellGroupData[{
Cell[36646, 1274, 101, 3, 45, "Input"],
Cell[36750, 1279, 137, 3, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36924, 1287, 150, 5, 45, "Input"],
Cell[37077, 1294, 117, 2, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37231, 1301, 106, 3, 46, "Input"],
Cell[37340, 1306, 203, 5, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37580, 1316, 155, 5, 46, "Input"],
Cell[37738, 1323, 251, 8, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38026, 1336, 44, 1, 45, "Input"],
Cell[38073, 1339, 2770, 43, 108, "Print",
 CellTags->"Info3583688783-1507343"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40880, 1387, 258, 8, 46, "Input"],
Cell[41141, 1397, 195, 5, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41373, 1407, 268, 8, 46, "Input"],
Cell[41644, 1417, 119, 2, 45, "Output"]
}, Open  ]],
Cell[41778, 1422, 104, 2, 24, "Text"],
Cell[CellGroupData[{
Cell[41907, 1428, 52, 1, 46, "Input"],
Cell[41962, 1431, 2880, 45, 124, "Print",
 CellTags->"Info3583688784-1507343"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44879, 1481, 114, 3, 46, "Input"],
Cell[44996, 1486, 225, 6, 61, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45258, 1497, 162, 5, 46, "Input"],
Cell[45423, 1504, 239, 7, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45699, 1516, 371, 12, 46, "Input"],
Cell[46073, 1530, 440, 14, 93, "Output"]
}, Open  ]],
Cell[46528, 1547, 1165, 25, 93, "Text"],
Cell[CellGroupData[{
Cell[47718, 1576, 491, 16, 46, "Input"],
Cell[48212, 1594, 188, 5, 49, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[48449, 1605, 153, 3, 47, "Subsection"],
Cell[48605, 1610, 516, 8, 57, "Text"],
Cell[49124, 1620, 112, 3, 46, "Input"],
Cell[49239, 1625, 3193, 45, 351, "Text"],
Cell[52435, 1672, 401, 6, 26, "Text"],
Cell[CellGroupData[{
Cell[52861, 1682, 54, 1, 45, "Input"],
Cell[52918, 1685, 139, 3, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53094, 1693, 54, 1, 45, "Input"],
Cell[53151, 1696, 117, 2, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53305, 1703, 167, 5, 45, "Input"],
Cell[53475, 1710, 298, 9, 64, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53810, 1724, 114, 3, 46, "Input"],
Cell[53927, 1729, 161, 4, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54125, 1738, 186, 5, 46, "Input"],
Cell[54314, 1745, 266, 8, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54617, 1758, 189, 6, 45, "Input"],
Cell[54809, 1766, 6260, 110, 268, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61106, 1881, 328, 11, 46, "Input"],
Cell[61437, 1894, 13372, 228, 268, "Output"]
}, Open  ]],
Cell[74824, 2125, 231, 4, 26, "Text"],
Cell[75058, 2131, 320, 11, 46, "Input"],
Cell[CellGroupData[{
Cell[75403, 2146, 88, 2, 46, "Input"],
Cell[75494, 2150, 258, 8, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[75789, 2163, 88, 2, 45, "Input"],
Cell[75880, 2167, 119, 2, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[76036, 2174, 372, 12, 46, "Input"],
Cell[76411, 2188, 64489, 1052, 322, "Output"]
}, Open  ]],
Cell[140915, 3243, 286, 5, 26, "Text"],
Cell[141204, 3250, 292, 8, 46, "Input"],
Cell[CellGroupData[{
Cell[141521, 3262, 93, 2, 46, "Input"],
Cell[141617, 3266, 171, 4, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[141825, 3275, 91, 2, 46, "Input"],
Cell[141919, 3279, 163, 4, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[142119, 3288, 91, 2, 46, "Input"],
Cell[142213, 3292, 256, 7, 63, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[142506, 3304, 138, 4, 45, "Input"],
Cell[142647, 3310, 121, 2, 45, "Output"]
}, Open  ]],
Cell[142783, 3315, 339, 5, 27, "Text"],
Cell[CellGroupData[{
Cell[143147, 3324, 44, 1, 45, "Input"],
Cell[143194, 3327, 118, 2, 40, "Print",
 CellTags->"Info3583688787-2646576"],
Cell[143315, 3331, 812, 23, 24, "Print",
 CellTags->"Info3583688787-2646576"]
}, Open  ]],
Cell[CellGroupData[{
Cell[144164, 3359, 45, 1, 45, "Input"],
Cell[144212, 3362, 119, 2, 40, "Print",
 CellTags->"Info3583688788-2646576"],
Cell[144334, 3366, 1013, 29, 36, "Print",
 CellTags->"Info3583688788-2646576"]
}, Open  ]],
Cell[CellGroupData[{
Cell[145384, 3400, 48, 1, 46, "Input"],
Cell[145435, 3403, 122, 2, 40, "Print",
 CellTags->"Info3583688789-2646576"],
Cell[145560, 3407, 1022, 28, 27, "Print",
 CellTags->"Info3583688789-2646576"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[146631, 3441, 61, 0, 44, "Subsection"],
Cell[146695, 3443, 4657, 67, 327, "Text"],
Cell[151355, 3512, 501, 13, 92, "Input"],
Cell[151859, 3527, 4003, 58, 309, "Text"],
Cell[CellGroupData[{
Cell[155887, 3589, 65, 1, 46, "Input"],
Cell[155955, 3592, 123, 2, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[156115, 3599, 66, 1, 46, "Input"],
Cell[156184, 3602, 147, 3, 45, "Output"]
}, Open  ]],
Cell[156346, 3608, 4314, 95, 446, "Text"],
Cell[160663, 3705, 3398, 81, 154, "Input"],
Cell[164064, 3788, 140, 3, 26, "Text"],
Cell[CellGroupData[{
Cell[164229, 3795, 436, 12, 62, "Input"],
Cell[164668, 3809, 333, 8, 22, "Print"],
Cell[165004, 3819, 806, 18, 32, "Print"],
Cell[165813, 3839, 371, 10, 59, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[166221, 3854, 157, 4, 45, "Input"],
Cell[166381, 3860, 289, 7, 23, "Print"],
Cell[166673, 3869, 672, 16, 32, "Print"],
Cell[167348, 3887, 322, 10, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[167707, 3902, 268, 8, 46, "Input"],
Cell[167978, 3912, 477, 14, 43, "Print"],
Cell[168458, 3928, 1537, 40, 58, "Print"],
Cell[169998, 3970, 941, 31, 82, "Output"]
}, Open  ]],
Cell[170954, 4004, 150, 3, 26, "Text"],
Cell[CellGroupData[{
Cell[171129, 4011, 687, 18, 46, "Input"],
Cell[171819, 4031, 478, 14, 43, "Print"],
Cell[172300, 4047, 1536, 40, 58, "Print"],
Cell[173839, 4089, 199, 4, 45, "Output"]
}, Open  ]],
Cell[174053, 4096, 2400, 34, 131, "Text"],
Cell[176456, 4132, 2111, 35, 131, "Text"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
